package org.skynetsoftware.fontwidgets.widget.android;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.DigitalClock;

import org.skynetsoftware.fontwidgets.TypefaceHolder;

/**
 * Created by pedja on 29.5.14. 16.37.
 * This class is part of the FontWidget
 * Copyright © 2014 ${OWNER}
 */
public class FDigitalClock extends DigitalClock
{
    public FDigitalClock(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        TypefaceHolder.getInstance().setTypeface(this, attrs);
    }

    public FDigitalClock(Context context)
    {
        super(context);
    }

    public void setTypeface(String assetName)
    {
        if(isInEditMode())return;
        setTypeface(TypefaceHolder.getInstance().getTypeface(getContext(), assetName, TypefaceHolder.Source.asset));
    }

    public void setTypeface(String assetName, TypefaceHolder.Source source)
    {
        if(isInEditMode())return;
        setTypeface(TypefaceHolder.getInstance().getTypeface(getContext(), assetName, source));
    }
}
