package org.skynetsoftware.fontwidgets.widget.android;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.CheckBox;

import org.skynetsoftware.fontwidgets.TypefaceHolder;

/**
 * Created by pedja on 29.5.14. 16.37.
 * This class is part of the FontWidget
 * Copyright © 2014 ${OWNER}
 */
public class FCheckBox extends CheckBox
{
    public FCheckBox(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        TypefaceHolder.getInstance().setTypeface(this, attrs);
    }

    public FCheckBox(Context context, AttributeSet attrs, int defStyle)
    {
        super(context, attrs, defStyle);
        TypefaceHolder.getInstance().setTypeface(this, attrs);
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public FCheckBox(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes)
    {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypefaceHolder.getInstance().setTypeface(this, attrs);
    }

    public FCheckBox(Context context)
    {
        super(context);
    }

    public void setTypeface(String assetName)
    {
        if(isInEditMode())return;
        setTypeface(TypefaceHolder.getInstance().getTypeface(getContext(), assetName, TypefaceHolder.Source.asset));
    }

    public void setTypeface(String assetName, TypefaceHolder.Source source)
    {
        if(isInEditMode())return;
        setTypeface(TypefaceHolder.getInstance().getTypeface(getContext(), assetName, source));
    }
}
