package org.skynetsoftware.fontwidgets;

import android.util.Log;

/**
 * Created by pedja on 29.5.14. 16.23.
 * This class is part of the FontWidget
 * Copyright © 2014 ${OWNER}
 */
public class Logger
{
    public static final int V = 0;
    public static final int D = 1;
    public static final int I = 2;
    public static final int W = 3;
    public static final int E = 4;
    public static final int A = 5;

    private static int logLevel = V;

    public static void setLogLevel(int logLevel)
    {
        if(logLevel < V && logLevel > A)
        {
            Log.w("Logger", "Logging disabled");
        }
        Logger.logLevel = logLevel;
    }

    public static void a(String tag, String message)
    {
        if(logLevel == A)Log.wtf(tag, message);
    }

    public static void e(String tag, String message)
    {
        if(logLevel == E)Log.e(tag, message);
    }

    public static void w(String tag, String message)
    {
        if(logLevel == W)Log.w(tag, message);
    }

    public static void i(String tag, String message)
    {
        if(logLevel == I)Log.i(tag, message);
    }

    public static void d(String tag, String message)
    {
        if(logLevel == D)Log.d(tag, message);
    }

    public static void v(String tag, String message)
    {
        if(logLevel >= V && logLevel <= A)Log.v(tag, message);
    }
}
