/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester.selenium;

import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.sitoolkit.tester.ScreenshotOperation;
import org.sitoolkit.tester.TestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SeleniumScreenshotOperation
implements ScreenshotOperation {
    private static final Logger LOG = LoggerFactory.getLogger(SeleniumScreenshotOperation.class);
    protected Robot robot;
    @Autowired
    WebDriver seleniumDriver;
    @Autowired
    TestContext current;
    private boolean resizeWindow = true;
    private int dialogWaitSpan = 500;

    public SeleniumScreenshotOperation() {
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            LOG.warn("", (Throwable)e);
        }
    }

    @Override
    public File get() {
        if (this.seleniumDriver instanceof TakesScreenshot) {
            if (this.isResizeWindow()) {
                Dimension bodySize = this.seleniumDriver.findElement(By.tagName((String)"body")).getSize();
                this.seleniumDriver.manage().window().setSize(bodySize);
            }
            File file = (File)((TakesScreenshot)this.seleniumDriver).getScreenshotAs(OutputType.FILE);
            return file;
        }
        LOG.warn("\u30c9\u30e9\u30a4\u30d0{}\u306f\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002", (Object)this.seleniumDriver.getClass().getName());
        return null;
    }

    public boolean isResizeWindow() {
        return this.resizeWindow;
    }

    public void setResizeWindow(boolean resizeWindow) {
        this.resizeWindow = resizeWindow;
    }

    @Override
    public File getWithDialog() {
        if (this.robot == null) {
            return null;
        }
        Rectangle windowRect = this.current.getWindowRect();
        if (windowRect == null || windowRect.isEmpty()) {
            return null;
        }
        try {
            File file = File.createTempFile("sit-tester", "");
            try {
                Thread.sleep(this.getDialogWaitSpan());
            }
            catch (InterruptedException e) {
                LOG.warn("\u30b9\u30ec\u30c3\u30c9\u306e\u5f85\u6a5f\u306b\u5931\u6557");
            }
            BufferedImage img = this.robot.createScreenCapture(windowRect);
            ImageIO.write((RenderedImage)img, "png", file);
            this.current.setWindowRect(null);
            return file;
        }
        catch (IOException e) {
            LOG.warn("\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e);
            return null;
        }
    }

    public int getDialogWaitSpan() {
        return this.dialogWaitSpan;
    }

    public void setDialogWaitSpan(int dialogWaitSpan) {
        this.dialogWaitSpan = dialogWaitSpan;
    }
}

