/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester.selenium;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.sitoolkit.tester.DialogScreenshotSupport;
import org.sitoolkit.tester.TestContext;
import org.sitoolkit.tester.TestScript;
import org.sitoolkit.tester.selenium.DialogOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SeleniumDialogScreenshotSupport
implements DialogScreenshotSupport {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private Set<String> windowSizeCheckNoSet = new HashSet<String>();
    @Autowired
    WebDriver seleniumDriver;
    @Autowired
    TestContext current;

    @Override
    public void checkReserve(List<TestScript> scripts, String caseNo) {
        block0: for (int i = scripts.size() - 1; i >= 0; --i) {
            TestScript script = scripts.get(i);
            script.setCurrentCaseNo(caseNo);
            if (script.isSkip() || !(script.getOperation() instanceof DialogOperation) || !script.beforeScreenshot()) continue;
            int reservedIdx = i;
            while (reservedIdx > 0) {
                TestScript reservedScript = scripts.get(reservedIdx);
                reservedScript.setCurrentCaseNo(caseNo);
                if (reservedScript.isSkip() || --reservedIdx != i - 2) continue;
                this.windowSizeCheckNoSet.add(reservedScript.getNo());
                script.addDialogScreenshotCaseNo(caseNo);
                continue block0;
            }
        }
        this.log.debug("\u30a6\u30a3\u30f3\u30c9\u30a6\u30b5\u30a4\u30ba\u306e\u4e8b\u524d\u53d6\u5f97\u304c\u5fc5\u8981\u306a\u30b9\u30af\u30ea\u30d7\u30c8No:{}", this.windowSizeCheckNoSet);
    }

    @Override
    public void reserveWindowRect(String testScriptNo) {
        if (this.windowSizeCheckNoSet.contains(testScriptNo)) {
            this.log.debug("\u30a6\u30a3\u30f3\u30c9\u30a6\u4f4d\u7f6e\u3001\u30b5\u30a4\u30ba\u3092\u53d6\u5f97\u3057\u307e\u3059");
            Point winPos = this.seleniumDriver.manage().window().getPosition();
            Dimension winSize = this.seleniumDriver.manage().window().getSize();
            this.current.setWindowRect(winPos.getX(), winPos.getY(), winSize.getWidth(), winSize.getHeight());
        }
    }
}

