/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester.selenium;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.commons.lang3.StringUtils;
import org.sitoolkit.tester.TestContext;
import org.sitoolkit.tester.TestException;
import org.sitoolkit.tester.TestScript;
import org.sitoolkit.tester.selenium.SeleniumOperation;
import org.springframework.beans.factory.annotation.Autowired;

public class OpenOperation
extends SeleniumOperation {
    @Autowired
    protected TestContext current;

    @Override
    public void execute(TestScript testScript) {
        String url = this.buildUrl(System.getProperty("baseUrl"), testScript.getLocator().getValue());
        this.info("\u30aa\u30fc\u30d7\u30f3", null);
        this.seleniumDriver.get(url);
    }

    protected String buildUrl(String baseUrl, String path) {
        if (path.startsWith("http:") || path.startsWith("https:")) {
            return path;
        }
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            return this.file2url(path);
        }
        if (baseUrl.startsWith("http:") || baseUrl.startsWith("https:")) {
            return this.concatPath(baseUrl, path);
        }
        return this.concatPath(this.file2url(baseUrl), path);
    }

    private String file2url(String url) {
        try {
            return new File(url).toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new TestException(e);
        }
    }

    private String concatPath(String a, String b) {
        return a.endsWith("/") ? a + b : a + "/" + b;
    }
}

