/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester.selenium;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;
import org.sitoolkit.tester.TestException;
import org.sitoolkit.tester.TestScript;
import org.sitoolkit.tester.selenium.SeleniumOperation;

public class InputOperation
extends SeleniumOperation {
    private static final String APPEND_PREFIX = "append:";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(TestScript testScript) {
        String value = testScript.getValue();
        WebElement element = this.findElement(testScript.getLocator());
        if ("file".equals(element.getAttribute("type"))) {
            File file = new File(value);
            if (!file.exists()) throw new TestException("\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093 " + file.getAbsolutePath());
            this.info(file.getAbsolutePath(), "\u5165\u529b", element);
            element.sendKeys(new CharSequence[]{file.getAbsolutePath()});
            return;
        } else {
            if (value.startsWith(APPEND_PREFIX)) {
                this.info(value, "\u5165\u529b(\u8ffd\u8a18)", element);
                value = StringUtils.substringAfter((String)value, (String)APPEND_PREFIX);
            } else {
                this.info(value, "\u5165\u529b(\u4e0a\u66f8)", element);
                element.clear();
            }
            element.sendKeys(new CharSequence[]{value});
        }
    }
}

