/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester.selenium;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.sitoolkit.tester.ElementPosition;
import org.sitoolkit.tester.OperationLog;
import org.sitoolkit.tester.TestException;
import org.sitoolkit.tester.TestScript;
import org.sitoolkit.tester.selenium.SeleniumOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ExecOperation
extends SeleniumOperation {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String CMD_SEPARATOR = "[\\s]+";
    @Autowired
    protected OperationLog opelog;

    @Override
    public void execute(TestScript testScript) {
        String cmd = testScript.getLocator().getValue();
        this.opelog.info(this.log, ElementPosition.EMPTY, "\u30b3\u30de\u30f3\u30c9[{}]\u3092\u5b9f\u884c\u3057\u307e\u3059\u3002", cmd);
        ProcessBuilder pb = new ProcessBuilder(cmd.split(CMD_SEPARATOR));
        pb.redirectErrorStream(true);
        Process process = null;
        String cmdlog = null;
        InputStream is = null;
        int exitValue = 0;
        try {
            process = pb.start();
            process.waitFor();
            is = process.getInputStream();
            cmdlog = IOUtils.toString((InputStream)is);
            exitValue = process.exitValue();
        }
        catch (Exception e) {
            try {
                throw new TestException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                process.destroy();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        process.destroy();
        if (!StringUtils.isEmpty((CharSequence)cmdlog)) {
            this.opelog.info(this.log, ElementPosition.EMPTY, cmdlog, new Object[0]);
        }
        if (exitValue != 0) {
            throw new TestException("\u30b3\u30de\u30f3\u30c9\u304c\u7570\u5e38\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002 " + cmd);
        }
    }
}

