/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester.selenium;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.sitoolkit.tester.Locator;
import org.sitoolkit.tester.TestScript;
import org.sitoolkit.tester.selenium.SeleniumOperation;

public class ChooseOperation
extends SeleniumOperation {
    @Override
    public void execute(TestScript testScript) {
        Object[] values = testScript.getValues();
        this.info(Arrays.toString(values), "\u9078\u629e", null);
        Map<String, Choice> map = this.toMap((String[])values);
        if ("label".equals(testScript.getDataType())) {
            this.chooseByLabel(testScript.getLocator(), map);
        } else {
            this.chooseByValue(testScript.getLocator(), map);
        }
    }

    protected void chooseByLabel(Locator locator, Map<String, Choice> map) {
        for (WebElement element : this.findElements(locator)) {
            String id = element.getAttribute("id");
            WebElement label = this.seleniumDriver.findElement(By.cssSelector((String)("label[for='" + id + "']")));
            String labelText = StringUtils.trim((String)label.getText());
            Choice choice = map.get(labelText);
            if (choice == null || !this.setChecked(element, label, choice.on)) continue;
            this.addPosition(element);
        }
    }

    protected void chooseByValue(Locator locator, Map<String, Choice> map) {
        for (WebElement element : this.findElements(locator)) {
            Choice choice = map.get(element.getAttribute("value"));
            if (choice == null || !this.setChecked(element, element, choice.on)) continue;
            this.addPosition(element);
        }
    }

    protected Map<String, Choice> toMap(String[] values) {
        HashMap<String, Choice> map = new HashMap<String, Choice>();
        for (String value : values) {
            Choice choice = new Choice();
            int idx = value.indexOf("_off");
            if (idx < 0) {
                choice.value = value;
                choice.on = true;
            } else {
                choice.value = value.substring(0, idx);
                choice.on = false;
            }
            map.put(choice.value, choice);
        }
        return map;
    }

    protected class Choice {
        protected String value;
        protected boolean on;

        protected Choice() {
        }
    }
}

