/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester;

import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.sitoolkit.core.infra.repository.DocumentRepository;
import org.sitoolkit.core.infra.repository.RowData;
import org.sitoolkit.core.infra.repository.TableData;
import org.sitoolkit.core.infra.repository.TableDataCatalog;
import org.sitoolkit.tester.Locator;
import org.sitoolkit.tester.Operation;
import org.sitoolkit.tester.TestException;
import org.sitoolkit.tester.TestScript;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class TestScriptConvertUtils {
    @Autowired
    ApplicationContext appCtx;
    @Autowired
    DocumentRepository docRepo;
    @Resource(name="seleniumIdeCommandMap")
    private Map<String, String> seleniumIdeCommandMap;
    private static String sheetName = "TestScript";
    private static final String CASE_NO = "001";

    public Operation getOperationBean(String seleniumCommand) {
        String operation = this.seleniumIdeCommandMap.get(seleniumCommand);
        if (operation == null) {
            return null;
        }
        try {
            return (Operation)Class.forName(operation).newInstance();
        }
        catch (Exception e) {
            throw new TestException(e);
        }
    }

    public TableDataCatalog getTableDataCatalog(List<TestScript> testScriptList) {
        TableDataCatalog tableDataCatalog = new TableDataCatalog();
        TableData tableData = new TableData();
        for (TestScript testScript : testScriptList) {
            RowData row = new RowData();
            row.setCellValue((Object)"No.", (Object)testScript.getNo());
            row.setCellValue((Object)"\u9805\u76ee\u540d", (Object)testScript.getItemName());
            row.setCellValue((Object)"\u64cd\u4f5c", (Object)testScript.getOperationName());
            if (!Locator.Type.na.equals(testScript.getLocator().getType())) {
                row.setCellValue((Object)"\u30ed\u30b1\u30fc\u30bf\u30fc\u5f62\u5f0f", (Object)testScript.getLocator().getType());
            }
            row.setCellValue((Object)"\u30ed\u30b1\u30fc\u30bf\u30fc", (Object)testScript.getLocator().getValue());
            row.setCellValue((Object)"\u30c7\u30fc\u30bf\u5f62\u5f0f", (Object)testScript.getDataType());
            row.setCellValue((Object)"\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8", (Object)testScript.getScreenshotTiming());
            row.setCellValue((Object)"\u30b1\u30fc\u30b9_001", (Object)testScript.getTestData().get(CASE_NO));
            tableData.add(row);
        }
        tableData.setName(sheetName);
        tableDataCatalog.add(tableData);
        return tableDataCatalog;
    }
}

