/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.sitoolkit.tester.ELSupport;
import org.sitoolkit.tester.Locator;
import org.sitoolkit.tester.Operation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class TestScript {
    @Autowired
    ELSupport el;
    private String no;
    private String itemName;
    private Operation operation;
    private String operationName;
    @Autowired
    private Locator locator;
    private String screenshotTiming;
    private String dataType;
    private Map<String, String> testData;
    private String currentCaseNo;
    private Set<String> dialogScreenshotCaseNoSet = new HashSet<String>();
    private String breakPoint;

    public void execute() {
        this.getOperation().execute(this);
    }

    public String getNo() {
        return this.no;
    }

    public void setNo(String no) {
        this.no = no;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    public String getValue() {
        String value = this.getTestData().get(this.getCurrentCaseNo());
        return this.el.evaludate(value);
    }

    public String[] getValues() {
        return StringUtils.isBlank((CharSequence)this.getValue()) ? new String[]{} : this.getValue().split("(:|;)");
    }

    public boolean getDialogValue() {
        String v = this.getValue().toLowerCase();
        return "true".equalsIgnoreCase(v) || "ok".equalsIgnoreCase(v) || "y".equalsIgnoreCase(v);
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public Map<String, String> getTestData() {
        return this.testData;
    }

    public void setTestData(Map<String, String> testData) {
        this.testData = testData;
    }

    public String getScreenshotTiming() {
        return this.screenshotTiming;
    }

    public void setScreenshotTiming(String screenshotTiming) {
        this.screenshotTiming = screenshotTiming;
    }

    public boolean beforeScreenshot() {
        return StringUtils.contains((CharSequence)this.getScreenshotTiming(), (CharSequence)"\u524d");
    }

    public boolean afterScreenshot() {
        return StringUtils.contains((CharSequence)this.getScreenshotTiming(), (CharSequence)"\u5f8c");
    }

    public boolean dialogScreenshot() {
        return this.dialogScreenshotCaseNoSet.contains(this.getCurrentCaseNo());
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = StringUtils.lowerCase((String)dataType);
    }

    public boolean isSkip() {
        return StringUtils.isBlank((CharSequence)this.getValue());
    }

    public String getCurrentCaseNo() {
        return this.currentCaseNo;
    }

    public void setCurrentCaseNo(String currentCaseNo) {
        this.currentCaseNo = currentCaseNo;
    }

    public void addDialogScreenshotCaseNo(String caseNo) {
        this.dialogScreenshotCaseNoSet.add(caseNo);
    }

    public String getBreakPoint() {
        return this.breakPoint;
    }

    public void setBreakPoint(String breakPoint) {
        this.breakPoint = breakPoint;
    }
}

