/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.lang.StringUtils;
import org.sitoolkit.core.infra.repository.DocumentMapper;
import org.sitoolkit.core.infra.repository.DocumentRepository;
import org.sitoolkit.core.infra.repository.RowData;
import org.sitoolkit.core.infra.repository.TableDataCatalog;
import org.sitoolkit.tester.Locator;
import org.sitoolkit.tester.OperationConverter;
import org.sitoolkit.tester.PageItemSpec;
import org.sitoolkit.tester.TestScript;
import org.sitoolkit.tester.TestScriptConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class PageSpecConverter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ApplicationContext appCtx;
    @Autowired
    OperationConverter operationConverter;
    @Autowired
    DocumentRepository repo;
    @Autowired
    TestScriptConvertUtils testScriptConvertUtils;
    @Resource(name="pageSpecConverterMap")
    Map<String, String> pageSpecConverterMap;
    private static final String SYSPROP_TEST_SCRIPT_DIR = "testScriptDir";
    private static final String TEMPLATE_PATH = "src/main/resources/TestScriptTemplate.xlsx";
    private static final String CASE_NO = "001";
    private static final String ITEM_DEF_SHEET_NAME = "\u9805\u76ee\u5b9a\u7fa9";

    public static void main(String[] args) {
        ClassPathXmlApplicationContext appCtx = new ClassPathXmlApplicationContext("classpath:sit-tester-conf.xml");
        PageSpecConverter converter = (PageSpecConverter)appCtx.getBean(PageSpecConverter.class);
        System.exit(converter.execute());
    }

    public int execute() {
        File scriptDir = new File(System.getProperty(SYSPROP_TEST_SCRIPT_DIR, "src/test/resources/pagespec"));
        if (!scriptDir.exists()) {
            scriptDir = new File(".");
        }
        for (File scriptFile : FileUtils.listFiles((File)scriptDir, (IOFileFilter)new PrefixFileFilter("\u753b\u9762\u5b9a\u7fa9\u66f8_"), (IOFileFilter)DirectoryFileFilter.DIRECTORY)) {
            this.convert(scriptFile);
        }
        return 0;
    }

    public File convert(File pageSpec) {
        String pageSpecPath = pageSpec.getAbsolutePath();
        String inputTestScript = StringUtils.substringBefore((String)StringUtils.substringAfter((String)pageSpecPath, (String)"_"), (String)".") + "TestScript.xlsx";
        List<PageItemSpec> pageItemSpeclist = this.loadPageSpec(pageSpecPath, ITEM_DEF_SHEET_NAME);
        ArrayList<TestScript> testScriptList = new ArrayList<TestScript>();
        int no = 1;
        for (PageItemSpec pageItemSpec : pageItemSpeclist) {
            testScriptList.add(this.convertPageItemSpec(no++, pageItemSpec));
        }
        TableDataCatalog catalog = this.testScriptConvertUtils.getTableDataCatalog(testScriptList);
        String scriptDir = System.getProperty(SYSPROP_TEST_SCRIPT_DIR, "src/test/resources/testscript");
        File testScriptFile = new File(scriptDir, inputTestScript);
        this.repo.write(TEMPLATE_PATH, testScriptFile.getPath(), catalog);
        return testScriptFile;
    }

    public List<PageItemSpec> loadPageSpec(String pageSpecPath, String sheetName) {
        ArrayList<PageItemSpec> pageItemSpecList = new ArrayList<PageItemSpec>();
        DocumentMapper dm = (DocumentMapper)this.appCtx.getBean(DocumentMapper.class);
        for (RowData row : this.repo.read(pageSpecPath, sheetName).getRows()) {
            PageItemSpec pageItemSpec = (PageItemSpec)dm.map("pageItemSpec", row, PageItemSpec.class);
            pageItemSpecList.add(pageItemSpec);
        }
        return pageItemSpecList;
    }

    private TestScript convertPageItemSpec(int no, PageItemSpec pageItemSpec) {
        TestScript testScript = (TestScript)this.appCtx.getBean(TestScript.class);
        testScript.setNo(Integer.toString(no));
        testScript.setCurrentCaseNo(CASE_NO);
        testScript.setItemName(pageItemSpec.getName());
        Locator locator = this.buildLocator(pageItemSpec.getName(), pageItemSpec.getPname());
        testScript.setLocator(locator);
        String operationName = this.pageSpecConverterMap.get(pageItemSpec.getControl());
        testScript.setOperationName(operationName);
        if ("click".equals(operationName)) {
            testScript.setScreenshotTiming("\u524d");
        }
        HashMap<String, String> testData = new HashMap<String, String>();
        testScript.setTestData(testData);
        String caseData = "select".equals(operationName) ? "" : "y";
        testData.put(CASE_NO, caseData);
        return testScript;
    }

    private Locator buildLocator(String name, String pName) {
        if (pName == null) {
            return Locator.build("id", name);
        }
        return Locator.build("id", pName);
    }
}

