/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.sitoolkit.core.infra.util.SitFileUtils;
import org.sitoolkit.tester.ElementPosition;
import org.sitoolkit.tester.LogLevelVo;
import org.sitoolkit.tester.LogRecord;
import org.sitoolkit.tester.SitPathUtils;
import org.sitoolkit.tester.TestContext;
import org.sitoolkit.tester.TestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;

@Component
public class OperationLog {
    @Autowired
    TestContext current;
    private static final Logger LOG = LoggerFactory.getLogger(OperationLog.class);
    private List<LogRecord> records = new ArrayList<LogRecord>();
    private String templatePath = "/opelog/opelog-template.vm";
    private String[] opelogResources = new String[]{"classpath:opelog/style.css", "classpath:opelog/jquery.js", "classpath:opelog/numbering.js"};
    private File opelogRootDir;
    private File imgDir;
    private String logFilePath = "target/sit-tester.log";
    private List<ElementPosition> positionList = new ArrayList<ElementPosition>();
    private Template tmpl;

    @PostConstruct
    public void init() {
        this.opelogRootDir = new File("target", "opelog_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        this.opelogRootDir.mkdirs();
        if (!this.opelogRootDir.exists()) {
            throw new TestException("\u64cd\u4f5c\u30ed\u30b0\u51fa\u529b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + this.opelogRootDir.getAbsoluteFile());
        }
        LOG.info("\u64cd\u4f5c\u30ed\u30b0\u51fa\u529b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3057\u307e\u3057\u305f\u3002{}", (Object)this.opelogRootDir.getAbsolutePath());
        this.imgDir = new File(this.opelogRootDir, "img");
        this.imgDir.mkdirs();
        if (!this.imgDir.exists()) {
            throw new TestException("\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u51fa\u529b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f" + this.imgDir.getAbsoluteFile());
        }
        try {
            Properties prop = SitFileUtils.resource2prop(this.getClass(), (String)"/velocity.properties");
            Velocity.init((Properties)prop);
            this.tmpl = Velocity.getTemplate((String)this.templatePath);
            for (String opelogRes : this.getOpelogResources()) {
                URL url = ResourceUtils.getURL((String)opelogRes);
                File dstFile = new File(this.opelogRootDir, StringUtils.substringAfterLast((String)url.getPath(), (String)"/"));
                FileUtils.copyURLToFile((URL)url, (File)dstFile);
            }
        }
        catch (IOException e) {
            throw new TestException(e);
        }
    }

    public void info(Logger log, String verb, ElementPosition pos) {
        this.info(log, pos, "{}({})\u3092{}\u3057\u307e\u3059", this.current.getTestScript().getItemName(), this.current.getTestScript().getLocator(), verb);
    }

    public void info(Logger log, String object, String verb, ElementPosition pos) {
        this.info(log, pos, "{}({})\u306b[{}]\u3092{}\u3057\u307e\u3059", this.current.getTestScript().getItemName(), this.current.getTestScript().getLocator(), object, verb);
    }

    public void info(Logger log, ElementPosition pos, String messagePattern, Object ... params) {
        String msg = MessageFormatter.arrayFormat((String)messagePattern, (Object[])params).getMessage();
        this.outLogAndAddRecord(log, msg, pos, LogLevelVo.INFO);
    }

    void outLogAndAddRecord(Logger log, String msg, ElementPosition pos, LogLevelVo logLevel) {
        LogRecord record = new LogRecord();
        switch (logLevel) {
            case DEBUG: {
                log.debug(msg);
                break;
            }
            case INFO: {
                log.info(msg);
                break;
            }
            case WARN: {
                log.warn(msg);
                break;
            }
            case ERROR: {
                log.error(msg);
                break;
            }
        }
        record.setLogLevel(logLevel);
        record.setNo(this.current.getTestScript().getNo());
        record.setLog(msg);
        this.records.add(record);
        this.addPosition(pos);
    }

    public void addPosition(ElementPosition pos) {
        if (pos != null && pos != ElementPosition.EMPTY) {
            pos.setNo(this.current.getTestScript().getNo());
            this.positionList.add(pos);
        }
    }

    public void addScreenshot(File file) {
        this.addScreenshot(file, "");
    }

    public void addScreenshot(File file, String timing) {
        this.addScreenshot(file, timing, true);
    }

    public void addScreenshot(File file, String timing, boolean withPos) {
        if (file == null) {
            this.renewPositionList();
            return;
        }
        File dstFile = new File(this.imgDir, this.screenshotFileName(this.current.getScriptName(), this.current.getCaseNo(), this.current.getTestScript().getNo(), this.current.getTestScript().getItemName(), timing));
        try {
            FileUtils.moveFile((File)file, (File)dstFile);
            LogRecord record = new LogRecord();
            record.setFilePath(SitPathUtils.relatvePath(this.opelogRootDir, dstFile));
            record.setLog(dstFile.getName());
            if (withPos) {
                record.setPositions(this.positionList);
            }
            this.records.add(record);
            LOG.info("\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u3092\u53d6\u5f97\u3057\u307e\u3057\u305f {}", (Object)dstFile.getAbsolutePath());
        }
        catch (IOException e) {
            LOG.warn("\u30b9\u30af\u30ea\u30fc\u30f3\u30b7\u30e7\u30c3\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u79fb\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e);
        }
    }

    String screenshotFileName(String scriptName, String caseNo, String scriptNo, String itemName, String timing) {
        return StringUtils.join((Object[])new String[]{scriptName, caseNo, scriptNo, itemName, timing}, (String)"_") + ".png";
    }

    String opelogFileName(String scriptName, String caseNo) {
        String resultHtml = ".html";
        if (this.hasError()) {
            resultHtml = "_NG.html";
        }
        return StringUtils.join((Object[])new String[]{scriptName, caseNo}, (String)"_") + resultHtml;
    }

    public void renewPositionList() {
        this.positionList = new ArrayList<ElementPosition>();
    }

    public void flush() {
        File htmlFile = new File(this.opelogRootDir, this.opelogFileName(this.current.getScriptName(), this.current.getCaseNo()));
        LOG.info("\u64cd\u4f5c\u30ed\u30b0\u3092\u51fa\u529b\u3057\u307e\u3059 {}", (Object)htmlFile.getAbsolutePath());
        try {
            String evidence = this.build(this.current.getCaseNo());
            FileUtils.write((File)htmlFile, (CharSequence)evidence, (String)"UTF-8");
        }
        catch (Exception e) {
            throw new TestException("\u64cd\u4f5c\u30ed\u30b0\u306e\u51fa\u529b\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
        }
        finally {
            this.records.clear();
            this.renewPositionList();
        }
    }

    public void moveLogFile() {
        try {
            File logFile = new File(this.getLogFilePath());
            FileUtils.copyFileToDirectory((File)logFile, (File)this.opelogRootDir, (boolean)true);
            logFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new TestException(e);
        }
    }

    String build(String caseNo) {
        VelocityContext context = new VelocityContext();
        StringWriter writer = new StringWriter();
        context.put("opeLog", (Object)this);
        context.put("caseNo", (Object)caseNo);
        context.put("testScriptName", (Object)this.current.getScriptName());
        context.put("result", (Object)(this.hasError() ? "NG" : ""));
        this.tmpl.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    public List<LogRecord> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    void error(Logger log, String msg) {
        LogRecord record = new LogRecord();
        log.error(msg);
        record.setNo(this.current.getTestScript().getNo());
        record.setLog(msg);
        record.setLogLevel(LogLevelVo.ERROR);
        this.records.add(record);
    }

    boolean hasError() {
        for (LogRecord logRecord : this.records) {
            if (!LogLevelVo.ERROR.equals((Object)logRecord.getLogLevel())) continue;
            return true;
        }
        return false;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public String[] getOpelogResources() {
        return this.opelogResources;
    }

    public void setOpelogResources(String[] opelogResources) {
        this.opelogResources = opelogResources;
    }
}

