/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester;

import org.apache.commons.lang3.StringUtils;
import org.sitoolkit.tester.ELSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class Locator {
    @Autowired
    ELSupport el;
    private String type = Type.na.name();
    private String value = "";

    public Type getTypeVo() {
        return Type.decode(this.getType());
    }

    public void setTypeVo(Type type) {
        this.setType(type == null ? Type.na.name() : type.name());
    }

    public String getValue() {
        return this.el == null ? this.value : this.el.evaludate(this.value);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isNa() {
        return Type.na.equals((Object)this.getTypeVo());
    }

    public static Locator build(String type, String value) {
        Locator locator = new Locator();
        if (StringUtils.isNotBlank((CharSequence)type)) {
            locator.setType(type);
        }
        locator.setValue(value);
        return locator;
    }

    public String toString() {
        return Type.na.name().equals(this.getType()) ? this.getValue() : this.getType() + "=" + this.getValue();
    }

    public static enum Type {
        id,
        css,
        name,
        xpath,
        link,
        tag,
        na;


        public static Type decode(String code) {
            for (Type type : Type.values()) {
                if (!type.name().equals(code)) continue;
                return type;
            }
            return na;
        }
    }
}

