/*
 * Decompiled with CFR 0.152.
 */
package org.sitoolkit.tester;

import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.sitoolkit.tester.TestContext;
import org.sitoolkit.tester.TestScript;
import org.sitoolkit.tester.TestScriptCatalog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DebugSupport {
    private static Logger LOG = LoggerFactory.getLogger(DebugSupport.class);
    private static final String CMD_PAUSE = "s";
    private static final String CMD_STEP_FORWARD = "n";
    private static final String CMD_CURRENT = "c";
    private static final String CMD_STEP_BACK = "p";
    private static final String CMD_EXEC_SCRIPT = "!";
    private static final String CMD_UPD_NUMBER = "#";
    @Autowired
    TestContext current;
    private int pauseSpan = 800;
    String input;
    String scriptNo;
    ExecutorService executor;
    private boolean paused = false;

    public boolean next() {
        TestScriptCatalog catalog;
        int currentIndex = this.current.getCurrentIndex();
        if (currentIndex < (catalog = this.current.getCatalog()).getTestScriptCount()) {
            if (this.isDebug()) {
                if (!StringUtils.isEmpty((CharSequence)catalog.getTestScript(currentIndex).getBreakPoint())) {
                    this.setPaused(true);
                }
                currentIndex = this.getNextIndex(currentIndex);
            }
            TestScript ts = catalog.getTestScript(currentIndex);
            this.current.setTestScript(ts);
            this.current.setCurrentIndex(++currentIndex);
            return true;
        }
        return false;
    }

    public boolean isDebug() {
        return "true".equalsIgnoreCase(System.getProperty("tester.debug", "false"));
    }

    protected int getNextIndex(int i) {
        if (this.isPaused()) {
            LOG.info("\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u5b9f\u884c\u3092\u4e00\u6642\u505c\u6b62\u4e2d\u3067\u3059");
        }
        while (this.isPaused()) {
            try {
                Thread.sleep(this.getPauseSpan());
            }
            catch (InterruptedException e) {
                LOG.warn("\u30b9\u30ec\u30c3\u30c9\u306e\u5f85\u6a5f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e);
            }
            if (this.current.getCatalog().isScriptFileChanged()) {
                LOG.info("\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u304c\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u518d\u8aad\u8fbc\u3057\u307e\u3059\u3002");
                this.current.getCatalog().reload();
            }
            if (this.input == null) continue;
            boolean shouldBreak = false;
            switch (this.input.toLowerCase()) {
                case "p": {
                    if (i <= 0) break;
                    LOG.info("\u30b9\u30af\u30ea\u30d7\u30c8\u756a\u53f7\u30921\u3064\u623b\u3057\u307e\u3059");
                    --i;
                    break;
                }
                case "c": {
                    LOG.info("\u73fe\u5728\u306e\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u3092\u5b9f\u884c\u3057\u307e\u3059");
                    --i;
                    shouldBreak = true;
                    break;
                }
                case "n": {
                    LOG.info("\u6b21\u306e\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u3092\u5b9f\u884c\u3057\u307e\u3059");
                    shouldBreak = true;
                    break;
                }
                case "!": {
                    LOG.info("No.{}\u306e\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u3092\u5b9f\u884c\u3057\u307e\u3059", (Object)this.scriptNo);
                    i = this.current.getCatalog().getIndexByScriptNo(this.scriptNo);
                    shouldBreak = true;
                    break;
                }
                case "#": {
                    LOG.info("\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u5b9f\u884c\u3092No.{}\u304b\u3089\u958b\u59cb\u3059\u308b\u3088\u3046\u306b\u8a2d\u5b9a\u3057\u307e\u3059", (Object)this.scriptNo);
                    i = this.current.getCatalog().getIndexByScriptNo(this.scriptNo);
                    break;
                }
                case "s": {
                    break;
                }
                default: {
                    this.usage();
                }
            }
            if (shouldBreak) break;
            this.input = null;
        }
        this.input = null;
        return i;
    }

    public void pause() {
        this.setPaused(true);
    }

    @PostConstruct
    public void init() {
        if (this.isDebug()) {
            LOG.info("\u30c7\u30d0\u30c3\u30b0\u30e2\u30fc\u30c9\u3067\u30c6\u30b9\u30c8\u3092\u5b9f\u884c\u3057\u307e\u3059\u3002\u5b9f\u884c\u3092\u4e00\u6642\u505c\u6b62\u3059\u308b\u306b\u306f\"s\"\u3092\u5165\u529b\u3057Enter\u30ad\u30fc\u3092\u30bf\u30a4\u30d7\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            this.executor = Executors.newSingleThreadExecutor();
            this.executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try (Scanner scan = new Scanner(System.in);){
                        while ((DebugSupport.this.input = scan.nextLine()) != null) {
                            if (DebugSupport.CMD_PAUSE.equalsIgnoreCase(DebugSupport.this.input)) {
                                DebugSupport.this.changeStatus();
                            }
                            if (StringUtils.startsWith((CharSequence)DebugSupport.this.input, (CharSequence)DebugSupport.CMD_UPD_NUMBER)) {
                                DebugSupport.this.scriptNo = StringUtils.substringAfter((String)DebugSupport.this.input, (String)DebugSupport.CMD_UPD_NUMBER);
                                DebugSupport.this.input = DebugSupport.CMD_UPD_NUMBER;
                            }
                            if (!StringUtils.startsWith((CharSequence)DebugSupport.this.input, (CharSequence)DebugSupport.CMD_EXEC_SCRIPT)) continue;
                            DebugSupport.this.scriptNo = StringUtils.substringAfter((String)DebugSupport.this.input, (String)DebugSupport.CMD_EXEC_SCRIPT);
                            DebugSupport.this.input = DebugSupport.CMD_EXEC_SCRIPT;
                        }
                    }
                }
            });
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.isDebug()) {
            this.executor.shutdownNow();
        }
    }

    private void changeStatus() {
        boolean bl = this.paused = !this.paused;
        if (this.paused) {
            LOG.info("\u30c6\u30b9\u30c8\u5b9f\u884c\u3092\u4e00\u6642\u505c\u6b62\u3057\u307e\u3059");
        } else {
            LOG.info("\u30c6\u30b9\u30c8\u5b9f\u884c\u3092\u518d\u958b\u3057\u307e\u3059");
        }
    }

    public int getPauseSpan() {
        return this.pauseSpan;
    }

    public void setPauseSpan(int pauseSpan) {
        this.pauseSpan = pauseSpan;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    private void usage() {
        LOG.info("\u30c7\u30d0\u30c3\u30b0\u64cd\u4f5c\u65b9\u6cd5\uff1a\ns    : \u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u5b9f\u884c\u3092\u4e00\u6642\u505c\u6b62/\u518d\u958b\u3057\u307e\u3059\nc    : \u73fe\u5728\u306e\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u3092\u5b9f\u884c\u3057\u307e\u3059\nn    : \u6b21\u306e\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u3092\u5b9f\u884c\u3057\u307e\u3059\np    : \u30b9\u30af\u30ea\u30d7\u30c8\u756a\u53f7\u30921\u3064\u623b\u3057\u307e\u3059\n!{0} : No.{0}\u306e\u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u3092\u5b9f\u884c\u3057\u307e\u3059\n#{0} : \u30c6\u30b9\u30c8\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u5b9f\u884c\u3092No.{0}\u304b\u3089\u958b\u59cb\u3059\u308b\u3088\u3046\u306b\u8a2d\u5b9a\u3057\u307e\u3059\n");
    }
}

