/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Stream;
import org.siouan.frontendgradleplugin.domain.FileManager;
import org.siouan.frontendgradleplugin.domain.Platform;

public class FileManagerImpl
implements FileManager {
    @Override
    public long copy(InputStream inputStream, Path filePath) throws IOException {
        return Files.copy(inputStream, filePath, new CopyOption[0]);
    }

    @Override
    public void copyFileTree(Path sourcePath, Path targetPath) throws IOException {
        Files.walkFileTree(sourcePath, new FileCopyVisitor(sourcePath, targetPath));
    }

    @Override
    public Path createDirectories(Path path) throws IOException {
        return Files.createDirectories(path, new FileAttribute[0]);
    }

    @Override
    public Path createDirectory(Path directoryPath) throws IOException {
        return Files.createDirectory(directoryPath, new FileAttribute[0]);
    }

    @Override
    public Path createSymbolicLink(Path linkFilePath, Path targetFilePath) throws IOException {
        return Files.createSymbolicLink(linkFilePath, targetFilePath, new FileAttribute[0]);
    }

    @Override
    public void delete(Path path) throws IOException {
        Files.delete(path);
    }

    @Override
    public boolean deleteIfExists(Path path) throws IOException {
        return Files.deleteIfExists(path);
    }

    @Override
    public void deleteFileTree(Path rootPath, boolean deleteRootEnabled) throws IOException {
        if (Files.exists(rootPath, new LinkOption[0])) {
            Files.walkFileTree(rootPath, new FileDeleteVisitor(rootPath, deleteRootEnabled));
        }
    }

    @Override
    public boolean exists(Path filePath) {
        return Files.exists(filePath, new LinkOption[0]);
    }

    @Override
    public boolean isDirectory(Path filePath) {
        return Files.isDirectory(filePath, new LinkOption[0]);
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) throws IOException {
        return Files.isSameFile(path1, path2);
    }

    @Override
    public Stream<Path> list(Path directoryPath) throws IOException {
        return Files.list(directoryPath);
    }

    @Override
    public Path move(Path sourcePath, Path targetPath, CopyOption ... options) throws IOException {
        return Files.move(sourcePath, targetPath, options);
    }

    @Override
    public BufferedReader newBufferedReader(Path filePath) throws IOException {
        return Files.newBufferedReader(filePath);
    }

    @Override
    public InputStream newInputStream(Path filePath) throws IOException {
        return Files.newInputStream(filePath, new OpenOption[0]);
    }

    @Override
    public OutputStream newOutputStream(Path filePath) throws IOException {
        return Files.newOutputStream(filePath, new OpenOption[0]);
    }

    @Override
    public void moveFileTree(Path sourcePath, Path targetPath) throws IOException {
        this.copyFileTree(sourcePath, targetPath);
        this.deleteFileTree(sourcePath, true);
    }

    @Override
    public String readString(Path path, Charset charset) throws IOException {
        return Files.readString(path, charset);
    }

    @Override
    public boolean setFileExecutable(Path path, Platform platform) throws IOException {
        boolean touched = !platform.isWindowsOs() && Files.exists(path, new LinkOption[0]) && !Files.isExecutable(path) ? this.setFileExecutable(path, Files.getPosixFilePermissions(path, new LinkOption[0]), platform) : false;
        return touched;
    }

    @Override
    public Path setPosixFilePermissions(Path path, Set<PosixFilePermission> permissions) throws IOException {
        return Files.setPosixFilePermissions(path, permissions);
    }

    @Override
    public Path writeString(Path path, CharSequence charSequence, Charset charset, OpenOption ... openOptions) throws IOException {
        return Files.writeString(path, charSequence, charset, openOptions);
    }

    private boolean setFileExecutable(Path path, Set<PosixFilePermission> originalPermissions, Platform platform) throws IOException {
        boolean touched;
        if (!platform.isWindowsOs() && Files.exists(path, new LinkOption[0]) && !Files.isExecutable(path)) {
            EnumSet<PosixFilePermission> newPermissions = EnumSet.copyOf(originalPermissions);
            newPermissions.add(PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(path, newPermissions);
            touched = true;
        } else {
            touched = false;
        }
        return touched;
    }

    public static class FileCopyVisitor
    extends SimpleFileVisitor<Path> {
        private final Path rootPath;
        private final Path targetPath;

        FileCopyVisitor(Path rootPath, Path targetPath) {
            this.rootPath = rootPath;
            this.targetPath = targetPath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes basicFileAttributes) throws IOException {
            Files.copy(file, this.targetPath.resolve(this.rootPath.relativize(file)).normalize(), StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
            Files.copy(file, this.targetPath.resolve(this.rootPath.relativize(file)).normalize(), StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
            return FileVisitResult.CONTINUE;
        }
    }

    public static class FileDeleteVisitor
    extends SimpleFileVisitor<Path> {
        private final Path rootPath;
        private final boolean deleteRootEnabled;

        FileDeleteVisitor(Path rootPath, boolean deleteRootEnabled) {
            this.rootPath = rootPath;
            this.deleteRootEnabled = deleteRootEnabled;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path directory, IOException e) throws IOException {
            if (e == null) {
                if (this.deleteRootEnabled || !directory.equals(this.rootPath)) {
                    Files.delete(directory);
                }
                return FileVisitResult.CONTINUE;
            }
            throw e;
        }
    }
}

