/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import lombok.Generated;
import org.siouan.frontendgradleplugin.domain.installer.HttpResponse;

public class LocalFileHttpResponse
implements HttpResponse {
    public static final String PROTOCOL = "file";
    private final Path localFilePath;

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }

    @Override
    public String getVersion() {
        return "N/A";
    }

    @Override
    public int getStatusCode() {
        return Files.exists(this.localFilePath, new LinkOption[0]) ? 200 : 404;
    }

    @Override
    public String getReasonPhrase() {
        return Files.exists(this.localFilePath, new LinkOption[0]) ? "Ok" : "Not Found";
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.localFilePath, new OpenOption[0]);
    }

    @Override
    public void close() {
    }

    @Generated
    LocalFileHttpResponse(Path localFilePath) {
        this.localFilePath = localFilePath;
    }

    @Generated
    public static LocalFileHttpResponseBuilder builder() {
        return new LocalFileHttpResponseBuilder();
    }

    @Generated
    public static class LocalFileHttpResponseBuilder {
        @Generated
        private Path localFilePath;

        @Generated
        LocalFileHttpResponseBuilder() {
        }

        @Generated
        public LocalFileHttpResponseBuilder localFilePath(Path localFilePath) {
            this.localFilePath = localFilePath;
            return this;
        }

        @Generated
        public LocalFileHttpResponse build() {
            return new LocalFileHttpResponse(this.localFilePath);
        }

        @Generated
        public String toString() {
            return "LocalFileHttpResponse.LocalFileHttpResponseBuilder(localFilePath=" + this.localFilePath + ")";
        }
    }
}

