/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.httpclient;

import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.siouan.frontendgradleplugin.domain.installer.HttpResponse;

public class ApacheHttpResponse
implements HttpResponse {
    private final CloseableHttpClient httpClient;
    private final ClassicHttpResponse httpResponse;

    @Override
    public String getProtocol() {
        return this.httpResponse.getVersion().getProtocol();
    }

    @Override
    public String getVersion() {
        return this.httpResponse.getVersion().getMajor() + "." + this.httpResponse.getVersion().getMinor();
    }

    @Override
    public int getStatusCode() {
        return this.httpResponse.getCode();
    }

    @Override
    public String getReasonPhrase() {
        return this.httpResponse.getReasonPhrase();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        HttpEntity httpEntity = this.httpResponse.getEntity();
        if (httpEntity == null) {
            return InputStream.nullInputStream();
        }
        return httpEntity.getContent();
    }

    @Override
    public void close() throws IOException {
        this.httpResponse.close();
        this.httpClient.close();
    }

    @Generated
    ApacheHttpResponse(CloseableHttpClient httpClient, ClassicHttpResponse httpResponse) {
        this.httpClient = httpClient;
        this.httpResponse = httpResponse;
    }

    @Generated
    public static ApacheHttpResponseBuilder builder() {
        return new ApacheHttpResponseBuilder();
    }

    @Generated
    public static class ApacheHttpResponseBuilder {
        @Generated
        private CloseableHttpClient httpClient;
        @Generated
        private ClassicHttpResponse httpResponse;

        @Generated
        ApacheHttpResponseBuilder() {
        }

        @Generated
        public ApacheHttpResponseBuilder httpClient(CloseableHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Generated
        public ApacheHttpResponseBuilder httpResponse(ClassicHttpResponse httpResponse) {
            this.httpResponse = httpResponse;
            return this;
        }

        @Generated
        public ApacheHttpResponse build() {
            return new ApacheHttpResponse(this.httpClient, this.httpResponse);
        }

        @Generated
        public String toString() {
            return "ApacheHttpResponse.ApacheHttpResponseBuilder(httpClient=" + this.httpClient + ", httpResponse=" + this.httpResponse + ")";
        }
    }
}

