/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.gradle.api.provider.Provider;
import org.siouan.frontendgradleplugin.domain.SystemProperties;
import org.siouan.frontendgradleplugin.domain.SystemSettingsProvider;
import org.siouan.frontendgradleplugin.infrastructure.gradle.SystemExtension;

public class SystemSettingsProviderImpl
implements SystemSettingsProvider {
    private final Provider<String> httpProxyHost;
    private final Provider<String> httpProxyPort;
    private final Provider<String> httpsProxyHost;
    private final Provider<String> httpsProxyPort;
    private final Provider<String> nonProxyHosts;
    private final Provider<String> jvmArch;
    private final Provider<String> osName;
    private final int defaultHttpProxyPort;
    private final int defaultHttpsProxyPort;

    public SystemSettingsProviderImpl(SystemExtension systemExtension, int defaultHttpProxyPort, int defaultHttpsProxyPort) {
        this.httpProxyHost = systemExtension.getHttpProxyHost();
        this.httpProxyPort = systemExtension.getHttpProxyPort();
        this.httpsProxyHost = systemExtension.getHttpsProxyHost();
        this.httpsProxyPort = systemExtension.getHttpsProxyPort();
        this.nonProxyHosts = systemExtension.getNonProxyHosts();
        this.jvmArch = systemExtension.getJvmArch();
        this.osName = systemExtension.getOsName();
        this.defaultHttpProxyPort = defaultHttpProxyPort;
        this.defaultHttpsProxyPort = defaultHttpsProxyPort;
    }

    @Override
    public String getHttpProxyHost() {
        return (String)this.httpProxyHost.getOrNull();
    }

    @Override
    public int getHttpProxyPort() {
        return Optional.ofNullable((String)this.httpProxyPort.getOrNull()).filter(port -> !port.isBlank()).map(Integer::parseInt).orElse(this.defaultHttpProxyPort);
    }

    @Override
    public String getHttpsProxyHost() {
        return (String)this.httpsProxyHost.getOrNull();
    }

    @Override
    public int getHttpsProxyPort() {
        return Optional.ofNullable((String)this.httpsProxyPort.getOrNull()).filter(port -> !port.isBlank()).map(Integer::parseInt).orElse(this.defaultHttpsProxyPort);
    }

    @Override
    public Set<String> getNonProxyHosts() {
        return Optional.ofNullable((String)this.nonProxyHosts.getOrNull()).filter(Predicate.not(String::isBlank)).map(hosts -> hosts.split(SystemProperties.NON_PROXY_HOSTS_SPLIT_PATTERN)).map(Set::of).orElseGet(Set::of);
    }

    @Override
    public String getSystemJvmArch() {
        return (String)this.jvmArch.get();
    }

    @Override
    public String getSystemOsName() {
        return (String)this.osName.get();
    }
}

