/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.siouan.frontendgradleplugin.domain.InvalidJsonFileException;
import org.siouan.frontendgradleplugin.domain.MalformedPackageManagerSpecification;
import org.siouan.frontendgradleplugin.domain.Platform;
import org.siouan.frontendgradleplugin.domain.PlatformProvider;
import org.siouan.frontendgradleplugin.domain.ResolvePackageManager;
import org.siouan.frontendgradleplugin.domain.ResolvePackageManagerCommand;
import org.siouan.frontendgradleplugin.domain.UnsupportedPackageManagerException;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanInstanciationException;
import org.siouan.frontendgradleplugin.infrastructure.bean.Beans;
import org.siouan.frontendgradleplugin.infrastructure.bean.TooManyCandidateBeansException;
import org.siouan.frontendgradleplugin.infrastructure.bean.ZeroOrMultiplePublicConstructorsException;
import org.siouan.frontendgradleplugin.infrastructure.gradle.TaskLoggerConfigurer;

@CacheableTask
public class ResolvePackageManagerTask
extends DefaultTask {
    private final String beanRegistryId;
    private final RegularFileProperty packageJsonFile;
    private final Property<File> nodeInstallDirectory;
    private final RegularFileProperty packageManagerSpecificationFile;
    private final RegularFileProperty packageManagerExecutablePathFile;

    @Inject
    public ResolvePackageManagerTask(ProjectLayout projectLayout, ObjectFactory objectFactory) {
        this.beanRegistryId = Beans.getBeanRegistryId(projectLayout.getProjectDirectory().toString());
        this.packageJsonFile = objectFactory.fileProperty();
        this.nodeInstallDirectory = objectFactory.property(File.class);
        this.packageManagerSpecificationFile = objectFactory.fileProperty();
        this.packageManagerExecutablePathFile = objectFactory.fileProperty();
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public RegularFileProperty getPackageJsonFile() {
        return this.packageJsonFile;
    }

    @Input
    public Property<File> getNodeInstallDirectory() {
        return this.nodeInstallDirectory;
    }

    @OutputFile
    public RegularFileProperty getPackageManagerSpecificationFile() {
        return this.packageManagerSpecificationFile;
    }

    @OutputFile
    public RegularFileProperty getPackageManagerExecutablePathFile() {
        return this.packageManagerExecutablePathFile;
    }

    @TaskAction
    public void execute() throws BeanInstanciationException, TooManyCandidateBeansException, ZeroOrMultiplePublicConstructorsException, IOException, InvalidJsonFileException, MalformedPackageManagerSpecification, UnsupportedPackageManagerException {
        Beans.getBean(this.beanRegistryId, TaskLoggerConfigurer.class).initLoggerAdapter((Task)this);
        Platform platform = Beans.getBean(this.beanRegistryId, PlatformProvider.class).getPlatform();
        this.getLogger().debug("Platform: {}", (Object)platform);
        Beans.getBean(this.beanRegistryId, ResolvePackageManager.class).execute(ResolvePackageManagerCommand.builder().packageJsonFilePath(((File)this.packageJsonFile.getAsFile().get()).toPath()).nodeInstallDirectoryPath((Path)this.nodeInstallDirectory.map(File::toPath).get()).platform(platform).packageManagerSpecificationFilePath(((File)this.packageManagerSpecificationFile.getAsFile().get()).toPath()).packageManagerExecutablePathFilePath(((File)this.packageManagerExecutablePathFile.getAsFile().get()).toPath()).build());
    }
}

