/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.siouan.frontendgradleplugin.domain.FrontendException;
import org.siouan.frontendgradleplugin.domain.Platform;
import org.siouan.frontendgradleplugin.domain.PlatformProvider;
import org.siouan.frontendgradleplugin.domain.installer.Credentials;
import org.siouan.frontendgradleplugin.domain.installer.InstallNodeDistribution;
import org.siouan.frontendgradleplugin.domain.installer.InstallNodeDistributionCommand;
import org.siouan.frontendgradleplugin.domain.installer.ProxySettings;
import org.siouan.frontendgradleplugin.domain.installer.ResolveProxySettingsByUrl;
import org.siouan.frontendgradleplugin.domain.installer.ResolveProxySettingsByUrlCommand;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanRegistryException;
import org.siouan.frontendgradleplugin.infrastructure.bean.Beans;
import org.siouan.frontendgradleplugin.infrastructure.gradle.TaskLoggerConfigurer;

public class InstallNodeTask
extends DefaultTask {
    protected final String beanRegistryId;
    private final Property<String> nodeVersion;
    private final Property<File> nodeInstallDirectory;
    private final Property<String> nodeDistributionUrlRoot;
    private final Property<String> nodeDistributionUrlPathPattern;
    private final Property<String> nodeDistributionServerUsername;
    private final Property<String> nodeDistributionServerPassword;
    private final RegularFileProperty nodeExecutableFile;
    protected final Property<String> httpProxyHost;
    protected final Property<Integer> httpProxyPort;
    protected final Property<String> httpProxyUsername;
    protected final Property<String> httpProxyPassword;
    protected final Property<String> httpsProxyHost;
    protected final Property<Integer> httpsProxyPort;
    protected final Property<String> httpsProxyUsername;
    protected final Property<String> httpsProxyPassword;

    @Inject
    public InstallNodeTask(ProjectLayout projectLayout, ObjectFactory objectFactory) {
        this.beanRegistryId = Beans.getBeanRegistryId(projectLayout.getProjectDirectory().toString());
        this.nodeVersion = objectFactory.property(String.class);
        this.nodeInstallDirectory = objectFactory.property(File.class);
        this.nodeDistributionUrlRoot = objectFactory.property(String.class);
        this.nodeDistributionUrlPathPattern = objectFactory.property(String.class);
        this.nodeDistributionServerUsername = objectFactory.property(String.class);
        this.nodeDistributionServerPassword = objectFactory.property(String.class);
        this.nodeExecutableFile = objectFactory.fileProperty();
        this.httpProxyHost = objectFactory.property(String.class);
        this.httpProxyPort = objectFactory.property(Integer.class);
        this.httpProxyUsername = objectFactory.property(String.class);
        this.httpProxyPassword = objectFactory.property(String.class);
        this.httpsProxyHost = objectFactory.property(String.class);
        this.httpsProxyPort = objectFactory.property(Integer.class);
        this.httpsProxyUsername = objectFactory.property(String.class);
        this.httpsProxyPassword = objectFactory.property(String.class);
    }

    @Input
    public Property<String> getNodeVersion() {
        return this.nodeVersion;
    }

    @Input
    public Property<String> getNodeDistributionUrlRoot() {
        return this.nodeDistributionUrlRoot;
    }

    @Input
    public Property<String> getNodeDistributionUrlPathPattern() {
        return this.nodeDistributionUrlPathPattern;
    }

    @Input
    public Property<File> getNodeInstallDirectory() {
        return this.nodeInstallDirectory;
    }

    @Internal
    public Property<String> getNodeDistributionServerUsername() {
        return this.nodeDistributionServerUsername;
    }

    @Internal
    public Property<String> getNodeDistributionServerPassword() {
        return this.nodeDistributionServerPassword;
    }

    @Internal
    public Property<String> getHttpProxyHost() {
        return this.httpProxyHost;
    }

    @Internal
    public Property<Integer> getHttpProxyPort() {
        return this.httpProxyPort;
    }

    @Internal
    public Property<String> getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    @Internal
    public Property<String> getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    @Internal
    public Property<String> getHttpsProxyHost() {
        return this.httpsProxyHost;
    }

    @Internal
    public Property<Integer> getHttpsProxyPort() {
        return this.httpsProxyPort;
    }

    @Internal
    public Property<String> getHttpsProxyUsername() {
        return this.httpsProxyUsername;
    }

    @Internal
    public Property<String> getHttpsProxyPassword() {
        return this.httpsProxyPassword;
    }

    @OutputFile
    public RegularFileProperty getNodeExecutableFile() {
        return this.nodeExecutableFile;
    }

    @TaskAction
    public void execute() throws BeanRegistryException, FrontendException, IOException {
        Beans.getBean(this.beanRegistryId, TaskLoggerConfigurer.class).initLoggerAdapter((Task)this);
        Credentials distributionServerCredentials = (Credentials)this.nodeDistributionServerUsername.map(username -> Credentials.builder().username((String)this.nodeDistributionServerUsername.get()).password((String)this.nodeDistributionServerPassword.get()).build()).getOrNull();
        Credentials httpProxyCredentials = (Credentials)this.httpProxyUsername.map(username -> Credentials.builder().username((String)username).password((String)this.httpProxyPassword.get()).build()).getOrNull();
        Credentials httpsProxyCredentials = (Credentials)this.httpsProxyUsername.map(username -> Credentials.builder().username((String)username).password((String)this.httpsProxyPassword.get()).build()).getOrNull();
        Platform platform = Beans.getBean(this.beanRegistryId, PlatformProvider.class).getPlatform();
        this.getLogger().debug("Platform: {}", (Object)platform);
        ProxySettings proxySettings = Beans.getBean(this.beanRegistryId, ResolveProxySettingsByUrl.class).execute(ResolveProxySettingsByUrlCommand.builder().httpsProxyHost((String)this.httpsProxyHost.getOrNull()).httpsProxyPort((Integer)this.httpsProxyPort.get()).httpsProxyCredentials(httpsProxyCredentials).httpProxyHost((String)this.httpProxyHost.getOrNull()).httpProxyPort((Integer)this.httpProxyPort.get()).httpProxyCredentials(httpProxyCredentials).resourceUrl(new URL((String)this.nodeDistributionUrlRoot.get())).build());
        Beans.getBean(this.beanRegistryId, InstallNodeDistribution.class).execute(InstallNodeDistributionCommand.builder().platform(platform).version((String)this.nodeVersion.get()).distributionUrlRoot((String)this.nodeDistributionUrlRoot.get()).distributionUrlPathPattern((String)this.nodeDistributionUrlPathPattern.get()).distributionServerCredentials(distributionServerCredentials).proxySettings(proxySettings).temporaryDirectoryPath(this.getTemporaryDir().toPath()).installDirectoryPath((Path)this.nodeInstallDirectory.map(File::toPath).get()).build());
    }
}

