/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.gradle.api.Action;
import org.gradle.process.ExecSpec;
import org.siouan.frontendgradleplugin.domain.ExecutionSettings;

public class ExecSpecAction
implements Action<ExecSpec> {
    private final ExecutionSettings executionSettings;
    private final Consumer<ExecSpec> afterConfiguredConsumer;

    public void execute(ExecSpec execSpec) {
        execSpec.setWorkingDir((Object)this.executionSettings.getWorkingDirectoryPath().toString());
        Map environment = execSpec.getEnvironment();
        String pathVariable = this.findPathVariable(environment);
        String executablePaths = this.executionSettings.getAdditionalExecutablePaths().stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator));
        StringBuilder pathValue = new StringBuilder();
        if (!executablePaths.isEmpty()) {
            pathValue.append(executablePaths);
            pathValue.append(File.pathSeparatorChar);
        }
        pathValue.append(environment.getOrDefault(pathVariable, ""));
        execSpec.environment(pathVariable, (Object)pathValue.toString());
        execSpec.setExecutable((Object)this.executionSettings.getExecutablePath());
        execSpec.setArgs(this.executionSettings.getArguments());
        this.afterConfiguredConsumer.accept(execSpec);
    }

    private String findPathVariable(Map<String, Object> environment) {
        String pathVariable = environment.containsKey("Path") ? "Path" : "PATH";
        return pathVariable;
    }

    @Generated
    ExecSpecAction(ExecutionSettings executionSettings, Consumer<ExecSpec> afterConfiguredConsumer) {
        this.executionSettings = executionSettings;
        this.afterConfiguredConsumer = afterConfiguredConsumer;
    }

    @Generated
    public static ExecSpecActionBuilder builder() {
        return new ExecSpecActionBuilder();
    }

    @Generated
    public ExecutionSettings getExecutionSettings() {
        return this.executionSettings;
    }

    @Generated
    public Consumer<ExecSpec> getAfterConfiguredConsumer() {
        return this.afterConfiguredConsumer;
    }

    @Generated
    public static class ExecSpecActionBuilder {
        @Generated
        private ExecutionSettings executionSettings;
        @Generated
        private Consumer<ExecSpec> afterConfiguredConsumer;

        @Generated
        ExecSpecActionBuilder() {
        }

        @Generated
        public ExecSpecActionBuilder executionSettings(ExecutionSettings executionSettings) {
            this.executionSettings = executionSettings;
            return this;
        }

        @Generated
        public ExecSpecActionBuilder afterConfiguredConsumer(Consumer<ExecSpec> afterConfiguredConsumer) {
            this.afterConfiguredConsumer = afterConfiguredConsumer;
            return this;
        }

        @Generated
        public ExecSpecAction build() {
            return new ExecSpecAction(this.executionSettings, this.afterConfiguredConsumer);
        }

        @Generated
        public String toString() {
            return "ExecSpecAction.ExecSpecActionBuilder(executionSettings=" + this.executionSettings + ", afterConfiguredConsumer=" + this.afterConfiguredConsumer + ")";
        }
    }
}

