/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.io.File;
import java.nio.file.Path;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.siouan.frontendgradleplugin.domain.ExecutableType;
import org.siouan.frontendgradleplugin.domain.Platform;
import org.siouan.frontendgradleplugin.domain.PlatformProvider;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanRegistryException;
import org.siouan.frontendgradleplugin.infrastructure.bean.Beans;
import org.siouan.frontendgradleplugin.infrastructure.gradle.GradleScriptRunnerAdapter;
import org.siouan.frontendgradleplugin.infrastructure.gradle.NonRunnableTaskException;
import org.siouan.frontendgradleplugin.infrastructure.gradle.ScriptProperties;
import org.siouan.frontendgradleplugin.infrastructure.gradle.TaskLoggerConfigurer;

public abstract class AbstractRunCommandTask
extends DefaultTask {
    protected final ExecOperations execOperations;
    protected final String beanRegistryId;
    protected final Property<File> packageJsonDirectory;
    protected final Property<File> nodeInstallDirectory;
    protected final Property<ExecutableType> executableType;
    protected final Property<String> script;

    AbstractRunCommandTask(ProjectLayout projectLayout, ObjectFactory objectFactory, ExecOperations execOperations) {
        this.execOperations = execOperations;
        this.beanRegistryId = Beans.getBeanRegistryId(projectLayout.getProjectDirectory().toString());
        this.packageJsonDirectory = objectFactory.property(File.class);
        this.nodeInstallDirectory = objectFactory.property(File.class);
        this.executableType = objectFactory.property(ExecutableType.class);
        this.script = objectFactory.property(String.class);
    }

    @Internal
    public Property<ExecutableType> getExecutableType() {
        return this.executableType;
    }

    @Input
    public Property<File> getPackageJsonDirectory() {
        return this.packageJsonDirectory;
    }

    @Input
    public Property<File> getNodeInstallDirectory() {
        return this.nodeInstallDirectory;
    }

    protected void assertThatTaskIsRunnable() throws NonRunnableTaskException {
        if (!this.script.isPresent()) {
            throw new NonRunnableTaskException("Missing property 'script'.");
        }
    }

    @TaskAction
    public void execute() throws NonRunnableTaskException, BeanRegistryException {
        this.assertThatTaskIsRunnable();
        Beans.getBean(this.beanRegistryId, TaskLoggerConfigurer.class).initLoggerAdapter((Task)this);
        Platform platform = Beans.getBean(this.beanRegistryId, PlatformProvider.class).getPlatform();
        this.getLogger().debug("Platform: {}", (Object)platform);
        Beans.getBean(this.beanRegistryId, GradleScriptRunnerAdapter.class).execute(ScriptProperties.builder().execOperations(this.execOperations).packageJsonDirectoryPath((Path)this.packageJsonDirectory.map(File::toPath).get()).executableType((ExecutableType)((Object)this.executableType.get())).nodeInstallDirectoryPath((Path)this.nodeInstallDirectory.map(File::toPath).get()).script((String)this.script.get()).platform(platform).build());
    }
}

