/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.bean;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanInstanciationException;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanRegistry;
import org.siouan.frontendgradleplugin.infrastructure.bean.TooManyCandidateBeansException;
import org.siouan.frontendgradleplugin.infrastructure.bean.ZeroOrMultiplePublicConstructorsException;

public final class Beans {
    private static final Beans INSTANCE = new Beans();
    private final Map<String, BeanRegistry> beanRegistryByIds = new ConcurrentHashMap<String, BeanRegistry>();

    private Beans() {
    }

    public static void initBeanRegistry(String registryId) {
        INSTANCE.findBeanRegistryById(registryId).ifPresentOrElse(BeanRegistry::init, () -> INSTANCE.addBeanRegistry(registryId, new BeanRegistry()));
    }

    public static String getBeanRegistryId(String decodedId) {
        return Base64.getEncoder().encodeToString(decodedId.getBytes(StandardCharsets.UTF_8));
    }

    public static <T> T getBean(String registryId, Class<T> beanClass) throws BeanInstanciationException, TooManyCandidateBeansException, ZeroOrMultiplePublicConstructorsException {
        return INSTANCE.findBeanRegistryByIdOrFail(registryId).getBean(beanClass);
    }

    public static <T> void registerBean(String registryId, Class<T> beanClass) {
        INSTANCE.findBeanRegistryByIdOrFail(registryId).registerBean(beanClass);
    }

    public static <T> void registerBean(String registryId, T bean) {
        INSTANCE.findBeanRegistryByIdOrFail(registryId).registerBean(bean);
    }

    public void addBeanRegistry(String registryId, BeanRegistry beanRegistry) {
        this.beanRegistryByIds.put(registryId, beanRegistry);
    }

    public BeanRegistry findBeanRegistryByIdOrFail(String registryId) {
        return this.findBeanRegistryById(registryId).orElseThrow(() -> new IllegalArgumentException("No registry was found with ID " + registryId));
    }

    public Optional<BeanRegistry> findBeanRegistryById(String registryId) {
        return Optional.ofNullable(this.beanRegistryByIds.get(registryId));
    }
}

