/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.bean;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanInstanciationException;
import org.siouan.frontendgradleplugin.infrastructure.bean.TooManyCandidateBeansException;
import org.siouan.frontendgradleplugin.infrastructure.bean.ZeroOrMultiplePublicConstructorsException;

public class BeanRegistry {
    private final Set<Class<?>> registeredBeanTypes = ConcurrentHashMap.newKeySet();
    private final Map<Class<?>, Object> singletons = new ConcurrentHashMap();

    public BeanRegistry() {
        this.init();
    }

    public void clear() {
        this.registeredBeanTypes.clear();
        this.singletons.clear();
    }

    public void init() {
        this.clear();
        this.registerBean(BeanRegistry.class, this);
    }

    public <T> T getBean(Class<T> beanClass) throws BeanInstanciationException, TooManyCandidateBeansException, ZeroOrMultiplePublicConstructorsException {
        Object existingBean = this.singletons.get(beanClass);
        if (existingBean != null) {
            return (T)existingBean;
        }
        Class assignableClass = this.getAssignableClass(beanClass);
        if (assignableClass != null) {
            return (T)this.getBean(assignableClass);
        }
        this.assertBeanClassIsInstanciable(beanClass);
        T newBean = this.createInstance(beanClass);
        this.registerBean(beanClass, newBean);
        return newBean;
    }

    public <T> void registerBean(Class<T> beanClass) {
        if (this.isBeanRegistered(beanClass)) {
            return;
        }
        this.assertBeanClassIsInstanciable(beanClass);
        this.registerBean(beanClass, null);
    }

    public <T> void registerBean(T bean) {
        Class<?> beanClass = bean.getClass();
        if (this.isBeanRegistered(beanClass)) {
            return;
        }
        this.registerBean(beanClass, bean);
    }

    private <T> void registerBean(Class<T> beanClass, T bean) {
        this.registeredBeanTypes.add(beanClass);
        if (bean != null) {
            this.singletons.put(beanClass, bean);
        }
    }

    private <T> boolean isBeanRegistered(Class<T> beanClass) {
        return this.getClass().isAssignableFrom(beanClass) || this.registeredBeanTypes.contains(beanClass);
    }

    private void assertBeanClassIsInstanciable(Class<?> beanClass) {
        if (beanClass.isInterface() || beanClass.isEnum() || (beanClass.getModifiers() & 0x400) != 0) {
            throw new IllegalArgumentException("An interface, an enumeration, or an abstract class can not be registered or instanciated: " + beanClass.getName());
        }
    }

    private <T, C extends T> Class<C> getAssignableClass(Class<T> beanClass) throws TooManyCandidateBeansException {
        Set assignableBeanClasses = this.registeredBeanTypes.stream().filter(clazz -> !clazz.equals(beanClass)).filter(beanClass::isAssignableFrom).map(clazz -> clazz).collect(Collectors.toSet());
        if (assignableBeanClasses.isEmpty()) {
            return null;
        }
        if (assignableBeanClasses.size() > 1) {
            throw new TooManyCandidateBeansException(beanClass, assignableBeanClasses);
        }
        return (Class)assignableBeanClasses.iterator().next();
    }

    private <T> T createInstance(Class<T> beanClass) throws BeanInstanciationException, ZeroOrMultiplePublicConstructorsException, TooManyCandidateBeansException {
        Constructor<?>[] constructors = beanClass.getConstructors();
        if (constructors.length != 1) {
            throw new ZeroOrMultiplePublicConstructorsException(beanClass);
        }
        Class<?>[] parameterTypes = constructors[0].getParameterTypes();
        Object[] parameters = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameters[i] = this.getBean(parameterTypes[i]);
        }
        try {
            return (T)beanClass.getConstructors()[0].newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new BeanInstanciationException(beanClass, (Throwable)e);
        }
    }
}

