/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.archiver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.siouan.frontendgradleplugin.domain.FileManager;
import org.siouan.frontendgradleplugin.domain.PathUtils;
import org.siouan.frontendgradleplugin.domain.installer.archiver.AbstractArchiver;
import org.siouan.frontendgradleplugin.domain.installer.archiver.ExplodeCommand;
import org.siouan.frontendgradleplugin.infrastructure.archiver.TarArchiverContext;
import org.siouan.frontendgradleplugin.infrastructure.archiver.TarEntry;
import org.siouan.frontendgradleplugin.infrastructure.archiver.UnexpectedEofException;

public class TarArchiver
extends AbstractArchiver<TarArchiverContext, TarEntry> {
    private final byte[] buffer = new byte[1024];

    public TarArchiver(FileManager fileManager) {
        super(fileManager);
    }

    @Override
    protected TarArchiverContext initializeContext(ExplodeCommand explodeCommand) throws IOException {
        InputStream archiveInputStream = null;
        try {
            archiveInputStream = this.fileManager.newInputStream(explodeCommand.getArchiveFilePath());
            return new TarArchiverContext(explodeCommand, this.buildLowLevelInputStream(this.uncompressInputStream(explodeCommand, archiveInputStream)));
        }
        catch (IOException e) {
            if (archiveInputStream != null) {
                archiveInputStream.close();
            }
            throw e;
        }
    }

    InputStream uncompressInputStream(ExplodeCommand command, InputStream compressedInputStream) throws IOException {
        InputStream uncompressedInputStream = PathUtils.getExtension(command.getArchiveFilePath()).filter(PathUtils::isGzipExtension).isPresent() ? new GzipCompressorInputStream(compressedInputStream) : compressedInputStream;
        return uncompressedInputStream;
    }

    TarArchiveInputStream buildLowLevelInputStream(InputStream inputStream) {
        return new TarArchiveInputStream(inputStream);
    }

    @Override
    protected Optional<TarEntry> getNextEntry(TarArchiverContext context) throws IOException {
        return Optional.ofNullable(context.getInputStream().getNextTarEntry()).map(TarEntry::new);
    }

    @Override
    protected String getSymbolicLinkTarget(TarArchiverContext context, TarEntry entry) {
        return entry.lowLevelEntry().getLinkName();
    }

    @Override
    protected void writeRegularFile(TarArchiverContext context, TarEntry entry, Path filePath) throws IOException {
        long entrySize = entry.lowLevelEntry().getSize();
        try (OutputStream outputStream = this.fileManager.newOutputStream(filePath);){
            int bytesRead;
            for (int bytesToRead = (int)entrySize; bytesToRead > 0; bytesToRead -= bytesRead) {
                bytesRead = context.getInputStream().read(this.buffer, 0, Math.min(bytesToRead, this.buffer.length));
                if (bytesRead == -1) {
                    throw new UnexpectedEofException(entry.getName(), entrySize, bytesRead);
                }
                outputStream.write(this.buffer, 0, bytesRead);
            }
        }
    }
}

