/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.archiver;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.siouan.frontendgradleplugin.domain.PathUtils;
import org.siouan.frontendgradleplugin.domain.installer.archiver.Archiver;
import org.siouan.frontendgradleplugin.domain.installer.archiver.ArchiverProvider;
import org.siouan.frontendgradleplugin.infrastructure.archiver.TarArchiver;
import org.siouan.frontendgradleplugin.infrastructure.archiver.ZipArchiver;

public class ArchiverProviderImpl
implements ArchiverProvider {
    private final Map<String, Archiver> registeredArchivers;

    public ArchiverProviderImpl(TarArchiver tarArchiver, ZipArchiver zipArchiver) {
        this.registeredArchivers = Map.of(".tar.gz", tarArchiver, ".zip", zipArchiver);
    }

    @Override
    public Optional<Archiver> findByArchiveFilePath(Path archiveFilePath) {
        return PathUtils.getExtension(archiveFilePath).flatMap(extension -> {
            Optional<String> newExtension = PathUtils.isGzipExtension(extension) ? PathUtils.getExtension(PathUtils.removeExtension(archiveFilePath)).map(ext -> ext + extension) : Optional.of(extension);
            return newExtension;
        }).map(this.registeredArchivers::get);
    }
}

