/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.installer.archiver;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.siouan.frontendgradleplugin.domain.FileManager;
import org.siouan.frontendgradleplugin.domain.installer.archiver.ArchiveEntry;
import org.siouan.frontendgradleplugin.domain.installer.archiver.Archiver;
import org.siouan.frontendgradleplugin.domain.installer.archiver.ArchiverContext;
import org.siouan.frontendgradleplugin.domain.installer.archiver.ArchiverException;
import org.siouan.frontendgradleplugin.domain.installer.archiver.DirectoryNotFoundException;
import org.siouan.frontendgradleplugin.domain.installer.archiver.ExplodeCommand;
import org.siouan.frontendgradleplugin.domain.installer.archiver.InvalidRelativizedSymbolicLinkTargetException;
import org.siouan.frontendgradleplugin.domain.installer.archiver.SlipAttackException;
import org.siouan.frontendgradleplugin.domain.installer.archiver.UnsupportedEntryException;

public abstract class AbstractArchiver<C extends ArchiverContext, E extends ArchiveEntry>
implements Archiver {
    private static final Map<Integer, PosixFilePermission> UNIX_MASK_TO_PERMISSION = Map.of(256, PosixFilePermission.OWNER_READ, 128, PosixFilePermission.OWNER_WRITE, 64, PosixFilePermission.OWNER_EXECUTE, 32, PosixFilePermission.GROUP_READ, 16, PosixFilePermission.GROUP_WRITE, 8, PosixFilePermission.GROUP_EXECUTE, 4, PosixFilePermission.OTHERS_READ, 2, PosixFilePermission.OTHERS_WRITE, 1, PosixFilePermission.OTHERS_EXECUTE);
    protected final FileManager fileManager;

    protected abstract C initializeContext(ExplodeCommand var1) throws ArchiverException, IOException;

    protected abstract Optional<E> getNextEntry(C var1) throws IOException;

    protected abstract String getSymbolicLinkTarget(C var1, E var2) throws IOException;

    @Override
    public void explode(ExplodeCommand command) throws ArchiverException, IOException {
        Path targetDirectoryPath = command.getTargetDirectoryPath();
        if (!this.fileManager.isDirectory(targetDirectoryPath)) {
            throw new DirectoryNotFoundException(targetDirectoryPath);
        }
        try (C context = this.initializeContext(command);){
            Optional<E> entry = this.getNextEntry(context);
            while (entry.isPresent()) {
                this.extractEntry(context, (ArchiveEntry)entry.get());
                entry = this.getNextEntry(context);
            }
        }
    }

    private void extractEntry(C context, E entry) throws ArchiverException, IOException {
        Path targetFilePath = context.getExplodeCommand().getTargetDirectoryPath().resolve(entry.getName());
        if (!targetFilePath.normalize().startsWith(context.getExplodeCommand().getTargetDirectoryPath().normalize())) {
            throw new SlipAttackException(entry.getName());
        }
        if (!this.fileManager.isDirectory(targetFilePath.getParent())) {
            this.fileManager.createDirectories(targetFilePath.getParent());
        }
        if (entry.isSymbolicLink()) {
            this.writeSymbolicLink(context, entry, targetFilePath);
        } else if (entry.isDirectory()) {
            this.writeDirectory(targetFilePath);
        } else if (entry.isFile()) {
            this.writeRegularFile(context, entry, targetFilePath);
        } else {
            throw new UnsupportedEntryException(entry.getName());
        }
        if (!entry.isSymbolicLink() && !context.getExplodeCommand().getPlatform().isWindowsOs()) {
            this.fileManager.setPosixFilePermissions(targetFilePath, this.toPosixPermissions(entry.getUnixMode()));
        }
    }

    private void writeSymbolicLink(C context, E entry, Path linkFilePath) throws IOException, ArchiverException {
        Path targetFilePath = linkFilePath.getParent().resolve(this.getSymbolicLinkTarget(context, entry));
        Path normalizedAndRelativizedTargetFilePath = linkFilePath.getParent().relativize(targetFilePath.normalize());
        this.fileManager.createSymbolicLink(linkFilePath, normalizedAndRelativizedTargetFilePath);
        Path relativizedTargetFilePath = linkFilePath.getParent().relativize(targetFilePath);
        if (!this.fileManager.isSameFile(relativizedTargetFilePath, normalizedAndRelativizedTargetFilePath) && (this.fileManager.exists(relativizedTargetFilePath) || this.fileManager.exists(normalizedAndRelativizedTargetFilePath))) {
            throw new InvalidRelativizedSymbolicLinkTargetException(entry.getName(), targetFilePath);
        }
    }

    private void writeDirectory(Path directoryPath) throws IOException {
        this.fileManager.createDirectory(directoryPath);
    }

    protected abstract void writeRegularFile(C var1, E var2, Path var3) throws IOException;

    private Set<PosixFilePermission> toPosixPermissions(int unixMode) {
        return UNIX_MASK_TO_PERMISSION.entrySet().stream().filter(entry -> ((Integer)entry.getKey() & unixMode) != 0).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    @Generated
    protected AbstractArchiver(FileManager fileManager) {
        this.fileManager = fileManager;
    }
}

