/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.installer;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import lombok.Generated;
import org.siouan.frontendgradleplugin.domain.FileManager;
import org.siouan.frontendgradleplugin.domain.Logger;
import org.siouan.frontendgradleplugin.domain.installer.BuildTemporaryFileName;
import org.siouan.frontendgradleplugin.domain.installer.DownloadResource;
import org.siouan.frontendgradleplugin.domain.installer.DownloadResourceCommand;
import org.siouan.frontendgradleplugin.domain.installer.HashFile;
import org.siouan.frontendgradleplugin.domain.installer.InvalidNodeDistributionException;
import org.siouan.frontendgradleplugin.domain.installer.NodeDistributionShasumNotFoundException;
import org.siouan.frontendgradleplugin.domain.installer.ReadNodeDistributionShasum;
import org.siouan.frontendgradleplugin.domain.installer.ReadNodeDistributionShasumCommand;
import org.siouan.frontendgradleplugin.domain.installer.ResourceDownloadException;
import org.siouan.frontendgradleplugin.domain.installer.ValidateNodeDistributionCommand;

public class ValidateNodeDistribution {
    public static final String SHASUMS_FILE_NAME = "SHASUMS256.txt";
    private final FileManager fileManager;
    private final BuildTemporaryFileName buildTemporaryFileName;
    private final DownloadResource downloadResource;
    private final ReadNodeDistributionShasum readNodeDistributionShasum;
    private final HashFile hashFile;
    private final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ValidateNodeDistributionCommand validateNodeDistributionCommand) throws InvalidNodeDistributionException, IOException, NodeDistributionShasumNotFoundException, ResourceDownloadException {
        String expectedShasum;
        Path shasumsFilePath = validateNodeDistributionCommand.getTemporaryDirectoryPath().resolve(SHASUMS_FILE_NAME);
        try {
            URL shasumsFileUrl = new URL(validateNodeDistributionCommand.getDistributionUrl(), SHASUMS_FILE_NAME);
            this.logger.debug("Downloading shasums at '{}'", shasumsFileUrl);
            Path temporaryFilePath = validateNodeDistributionCommand.getTemporaryDirectoryPath().resolve(this.buildTemporaryFileName.execute(shasumsFilePath.getFileName().toString()));
            this.downloadResource.execute(DownloadResourceCommand.builder().resourceUrl(shasumsFileUrl).serverCredentials(validateNodeDistributionCommand.getDistributionServerCredentials()).proxySettings(validateNodeDistributionCommand.getProxySettings()).temporaryFilePath(temporaryFilePath).destinationFilePath(shasumsFilePath).build());
            this.logger.info("Verifying distribution integrity", new Object[0]);
            String distributionFileName = validateNodeDistributionCommand.getDistributionFilePath().getFileName().toString();
            expectedShasum = this.readNodeDistributionShasum.execute(ReadNodeDistributionShasumCommand.builder().distributionFileName(distributionFileName).nodeDistributionShasumFilePath(shasumsFilePath).build()).orElseThrow(() -> new NodeDistributionShasumNotFoundException(distributionFileName));
        }
        finally {
            this.fileManager.deleteIfExists(shasumsFilePath);
        }
        if (!this.hashFile.execute(validateNodeDistributionCommand.getDistributionFilePath()).equals(expectedShasum)) {
            throw new InvalidNodeDistributionException();
        }
    }

    @Generated
    public ValidateNodeDistribution(FileManager fileManager, BuildTemporaryFileName buildTemporaryFileName, DownloadResource downloadResource, ReadNodeDistributionShasum readNodeDistributionShasum, HashFile hashFile, Logger logger) {
        this.fileManager = fileManager;
        this.buildTemporaryFileName = buildTemporaryFileName;
        this.downloadResource = downloadResource;
        this.readNodeDistributionShasum = readNodeDistributionShasum;
        this.hashFile = hashFile;
        this.logger = logger;
    }
}

