/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.installer;

import java.net.URL;
import lombok.Generated;
import org.siouan.frontendgradleplugin.domain.SystemSettingsProvider;
import org.siouan.frontendgradleplugin.domain.installer.IsNonProxyHost;
import org.siouan.frontendgradleplugin.domain.installer.IsNonProxyHostCommand;
import org.siouan.frontendgradleplugin.domain.installer.ProxySettings;
import org.siouan.frontendgradleplugin.domain.installer.ResolveProxySettingsByUrlCommand;
import org.siouan.frontendgradleplugin.domain.installer.SelectProxySettings;
import org.siouan.frontendgradleplugin.domain.installer.SelectProxySettingsCommand;

public class ResolveProxySettingsByUrl {
    private static final String FILE_PROTOCOL = "file";
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private final SystemSettingsProvider systemSettingsProvider;
    private final IsNonProxyHost isNonProxyHost;
    private final SelectProxySettings selectProxySettings;

    public ProxySettings execute(ResolveProxySettingsByUrlCommand command) {
        URL resourceUrl = command.resourceUrl();
        String resourceProtocol = resourceUrl.getProtocol();
        if (resourceProtocol.equals(HTTP_PROTOCOL) || resourceProtocol.equals(HTTPS_PROTOCOL)) {
            if (this.isNonProxyHost.execute(IsNonProxyHostCommand.builder().nonProxyHosts(this.systemSettingsProvider.getNonProxyHosts()).hostNameOrIpAddress(resourceUrl.getHost()).build())) {
                return null;
            }
            SelectProxySettingsCommand.SelectProxySettingsCommandBuilder selectProxySettingsCommandBuilder = SelectProxySettingsCommand.builder();
            if (resourceProtocol.equals(HTTPS_PROTOCOL)) {
                selectProxySettingsCommandBuilder.systemProxyHost(this.systemSettingsProvider.getHttpsProxyHost()).systemProxyPort(this.systemSettingsProvider.getHttpsProxyPort()).proxyHost(command.httpsProxyHost()).proxyPort(command.httpsProxyPort()).proxyCredentials(command.httpsProxyCredentials());
            } else {
                selectProxySettingsCommandBuilder.systemProxyHost(this.systemSettingsProvider.getHttpProxyHost()).systemProxyPort(this.systemSettingsProvider.getHttpProxyPort()).proxyHost(command.httpProxyHost()).proxyPort(command.httpProxyPort()).proxyCredentials(command.httpProxyCredentials());
            }
            return this.selectProxySettings.execute(selectProxySettingsCommandBuilder.build());
        }
        if (resourceProtocol.equals(FILE_PROTOCOL)) {
            return null;
        }
        throw new IllegalArgumentException("Unsupported protocol: " + resourceUrl.getProtocol());
    }

    @Generated
    public ResolveProxySettingsByUrl(SystemSettingsProvider systemSettingsProvider, IsNonProxyHost isNonProxyHost, SelectProxySettings selectProxySettings) {
        this.systemSettingsProvider = systemSettingsProvider;
        this.isNonProxyHost = isNonProxyHost;
        this.selectProxySettings = selectProxySettings;
    }
}

