/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.installer;

import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import lombok.Generated;
import org.siouan.frontendgradleplugin.domain.ChannelProvider;
import org.siouan.frontendgradleplugin.domain.FileManager;
import org.siouan.frontendgradleplugin.domain.Logger;
import org.siouan.frontendgradleplugin.domain.installer.DownloadResourceCommand;
import org.siouan.frontendgradleplugin.domain.installer.HttpClientProvider;
import org.siouan.frontendgradleplugin.domain.installer.HttpResponse;
import org.siouan.frontendgradleplugin.domain.installer.ProxySettings;
import org.siouan.frontendgradleplugin.domain.installer.ResourceDownloadException;

public class DownloadResource {
    private final FileManager fileManager;
    private final ChannelProvider channelProvider;
    private final HttpClientProvider httpClientProvider;
    private final Logger logger;

    public void execute(DownloadResourceCommand downloadResourceCommand) throws IOException, ResourceDownloadException {
        URL resourceUrl = downloadResourceCommand.getResourceUrl();
        ProxySettings proxySettings = downloadResourceCommand.getProxySettings();
        if (proxySettings == null) {
            this.logger.info("Downloading resource at '{}' (proxy: DIRECT)", downloadResourceCommand.getResourceUrl());
        } else {
            this.logger.info("Downloading resource at '{}' (proxy: {}/{}:{})", new Object[]{downloadResourceCommand.getResourceUrl(), proxySettings.getProxyType(), proxySettings.getProxyHost(), proxySettings.getProxyPort()});
        }
        try (HttpResponse response = this.httpClientProvider.getInstance().sendGetRequest(resourceUrl, downloadResourceCommand.getServerCredentials(), proxySettings);
             ReadableByteChannel resourceInputChannel = this.channelProvider.getReadableByteChannel(response.getInputStream());
             FileChannel resourceOutputChannel = this.channelProvider.getWritableFileChannelForNewFile(downloadResourceCommand.getTemporaryFilePath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.logger.debug("---> {}/{} {} {}", response.getProtocol(), response.getVersion(), response.getStatusCode(), response.getReasonPhrase());
            if (response.getStatusCode() != 200) {
                throw new ResourceDownloadException("Unexpected HTTP response: " + response.getProtocol() + "/" + response.getVersion() + " " + response.getStatusCode() + " " + response.getReasonPhrase());
            }
            resourceOutputChannel.transferFrom(resourceInputChannel, 0L, Long.MAX_VALUE);
        }
        catch (IOException | ResourceDownloadException e) {
            this.fileManager.deleteIfExists(downloadResourceCommand.getTemporaryFilePath());
            throw e;
        }
        this.fileManager.move(downloadResourceCommand.getTemporaryFilePath(), downloadResourceCommand.getDestinationFilePath(), StandardCopyOption.REPLACE_EXISTING);
    }

    @Generated
    public DownloadResource(FileManager fileManager, ChannelProvider channelProvider, HttpClientProvider httpClientProvider, Logger logger) {
        this.fileManager = fileManager;
        this.channelProvider = channelProvider;
        this.httpClientProvider = httpClientProvider;
        this.logger = logger;
    }
}

