/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.installer;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.siouan.frontendgradleplugin.domain.FileManager;
import org.siouan.frontendgradleplugin.domain.Logger;
import org.siouan.frontendgradleplugin.domain.installer.DeployDistributionCommand;
import org.siouan.frontendgradleplugin.domain.installer.UnsupportedDistributionArchiveException;
import org.siouan.frontendgradleplugin.domain.installer.archiver.ArchiverException;
import org.siouan.frontendgradleplugin.domain.installer.archiver.ArchiverProvider;
import org.siouan.frontendgradleplugin.domain.installer.archiver.ExplodeCommand;

public class DeployDistribution {
    private final FileManager fileManager;
    private final ArchiverProvider archiverProvider;
    private final Logger logger;

    public void execute(DeployDistributionCommand command) throws UnsupportedDistributionArchiveException, ArchiverException, IOException {
        Set distributionFilePaths;
        Path temporaryDirectoryPath = this.fileManager.createDirectory(command.getTemporaryDirectoryPath());
        this.logger.info("Exploding distribution into '{}'", temporaryDirectoryPath);
        Path distributionFilePath = command.getDistributionFilePath();
        this.archiverProvider.findByArchiveFilePath(distributionFilePath).orElseThrow(() -> new UnsupportedDistributionArchiveException(distributionFilePath)).explode(ExplodeCommand.builder().platform(command.getPlatform()).archiveFilePath(distributionFilePath).targetDirectoryPath(temporaryDirectoryPath).build());
        Path installDirectoryPath = command.getInstallDirectoryPath();
        this.logger.info("Moving distribution into '{}'", installDirectoryPath);
        try (Stream<Path> childFilePaths = this.fileManager.list(temporaryDirectoryPath);){
            distributionFilePaths = childFilePaths.collect(Collectors.toSet());
        }
        Path distributionRootDirectoryPath = distributionFilePaths.size() == 1 ? (Path)distributionFilePaths.iterator().next() : temporaryDirectoryPath;
        this.fileManager.moveFileTree(distributionRootDirectoryPath, installDirectoryPath);
        this.logger.info("Removing explode directory '{}'", temporaryDirectoryPath);
        this.fileManager.deleteIfExists(temporaryDirectoryPath);
    }

    @Generated
    public DeployDistribution(FileManager fileManager, ArchiverProvider archiverProvider, Logger logger) {
        this.fileManager = fileManager;
        this.archiverProvider = archiverProvider;
        this.logger = logger;
    }
}

