/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain;

import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public final class PathUtils {
    private static final Set<String> GZIP_EXTENSIONS = Set.of(".gz", ".gzip");

    public static Optional<String> getExtension(Path filePath) {
        return Optional.ofNullable(filePath.getFileName()).map(Path::toString).flatMap(PathUtils::getExtension);
    }

    public static Optional<String> getExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return Optional.empty();
        }
        return Optional.of(fileName.substring(fileName.lastIndexOf(46)));
    }

    public static String removeExtension(Path filePath) {
        Path leafFilePath = filePath.getFileName();
        if (leafFilePath == null) {
            return filePath.toString();
        }
        String leafFilePathAsString = leafFilePath.toString();
        int index = leafFilePathAsString.lastIndexOf(46);
        if (index == -1) {
            return leafFilePathAsString;
        }
        return leafFilePathAsString.substring(0, index);
    }

    public static boolean isGzipExtension(String extension) {
        return GZIP_EXTENSIONS.contains(extension);
    }

    @Generated
    private PathUtils() {
    }
}

