/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain;

import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.siouan.frontendgradleplugin.domain.ExecutableType;

public enum PackageManagerType {
    NPM("npm", ExecutableType.NPM),
    PNPM("pnpm", ExecutableType.PNPM),
    YARN("yarn", ExecutableType.YARN);

    private final String packageManagerName;
    private final ExecutableType executableType;

    public static Optional<PackageManagerType> fromPackageManagerName(String packageManagerName) {
        return Arrays.stream(PackageManagerType.values()).filter(packageManagerType -> packageManagerType.packageManagerName.equals(packageManagerName)).findAny();
    }

    @Generated
    private PackageManagerType(String packageManagerName, ExecutableType executableType) {
        this.packageManagerName = packageManagerName;
        this.executableType = executableType;
    }

    @Generated
    public String getPackageManagerName() {
        return this.packageManagerName;
    }

    @Generated
    public ExecutableType getExecutableType() {
        return this.executableType;
    }
}

