/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain;

import java.nio.file.Path;
import lombok.Generated;
import org.siouan.frontendgradleplugin.domain.ExecutableType;
import org.siouan.frontendgradleplugin.domain.GetExecutablePathCommand;
import org.siouan.frontendgradleplugin.domain.ResolveGlobalCorepackExecutablePath;
import org.siouan.frontendgradleplugin.domain.ResolveGlobalExecutablePathCommand;
import org.siouan.frontendgradleplugin.domain.ResolveGlobalNodeExecutablePath;
import org.siouan.frontendgradleplugin.domain.ResolveGlobalNpmExecutablePath;
import org.siouan.frontendgradleplugin.domain.ResolveGlobalPnpmExecutablePath;
import org.siouan.frontendgradleplugin.domain.ResolveGlobalYarnExecutablePath;

public class GetExecutablePath {
    private final ResolveGlobalCorepackExecutablePath getCorepackExecutablePath;
    private final ResolveGlobalNodeExecutablePath getNodeExecutablePath;
    private final ResolveGlobalNpmExecutablePath getNpmExecutablePath;
    private final ResolveGlobalPnpmExecutablePath getPnpmExecutablePath;
    private final ResolveGlobalYarnExecutablePath getYarnExecutablePath;

    public Path execute(GetExecutablePathCommand command) {
        ResolveGlobalExecutablePathCommand resolveGlobalExecutablePathCommand = ResolveGlobalExecutablePathCommand.builder().platform(command.getPlatform()).nodeInstallDirectoryPath(command.getNodeInstallDirectoryPath()).build();
        return switch (command.getExecutableType()) {
            default -> throw new IncompatibleClassChangeError();
            case ExecutableType.COREPACK -> this.getCorepackExecutablePath.execute(resolveGlobalExecutablePathCommand);
            case ExecutableType.NODE -> this.getNodeExecutablePath.execute(resolveGlobalExecutablePathCommand);
            case ExecutableType.NPM -> this.getNpmExecutablePath.execute(resolveGlobalExecutablePathCommand);
            case ExecutableType.PNPM -> this.getPnpmExecutablePath.execute(resolveGlobalExecutablePathCommand);
            case ExecutableType.YARN -> this.getYarnExecutablePath.execute(resolveGlobalExecutablePathCommand);
        };
    }

    @Generated
    public GetExecutablePath(ResolveGlobalCorepackExecutablePath getCorepackExecutablePath, ResolveGlobalNodeExecutablePath getNodeExecutablePath, ResolveGlobalNpmExecutablePath getNpmExecutablePath, ResolveGlobalPnpmExecutablePath getPnpmExecutablePath, ResolveGlobalYarnExecutablePath getYarnExecutablePath) {
        this.getCorepackExecutablePath = getCorepackExecutablePath;
        this.getNodeExecutablePath = getNodeExecutablePath;
        this.getNpmExecutablePath = getNpmExecutablePath;
        this.getPnpmExecutablePath = getPnpmExecutablePath;
        this.getYarnExecutablePath = getYarnExecutablePath;
    }
}

