/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.siouan.frontendgradleplugin.domain.ExecutableType;
import org.siouan.frontendgradleplugin.domain.FileManager;
import org.siouan.frontendgradleplugin.domain.MalformedPackageManagerSpecification;
import org.siouan.frontendgradleplugin.domain.ParsePackageManagerSpecification;
import org.siouan.frontendgradleplugin.domain.PlatformProvider;
import org.siouan.frontendgradleplugin.domain.ResolveGlobalExecutablePathCommand;
import org.siouan.frontendgradleplugin.domain.ResolveGlobalNodeExecutablePath;
import org.siouan.frontendgradleplugin.domain.UnsupportedPackageManagerException;
import org.siouan.frontendgradleplugin.infrastructure.archiver.ArchiverProviderImpl;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanInstanciationException;
import org.siouan.frontendgradleplugin.infrastructure.bean.Beans;
import org.siouan.frontendgradleplugin.infrastructure.bean.TooManyCandidateBeansException;
import org.siouan.frontendgradleplugin.infrastructure.bean.ZeroOrMultiplePublicConstructorsException;
import org.siouan.frontendgradleplugin.infrastructure.gradle.AssembleTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.CheckTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.CleanTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.FrontendExtension;
import org.siouan.frontendgradleplugin.infrastructure.gradle.GradleLoggerAdapter;
import org.siouan.frontendgradleplugin.infrastructure.gradle.GradleSettings;
import org.siouan.frontendgradleplugin.infrastructure.gradle.InstallFrontendTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.InstallNodeTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.InstallPackageManagerTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.PublishTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.ResolveNodeInstallDirectoryPath;
import org.siouan.frontendgradleplugin.infrastructure.gradle.ResolveNodeInstallDirectoryPathCommand;
import org.siouan.frontendgradleplugin.infrastructure.gradle.ResolvePackageManagerTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.SystemExtension;
import org.siouan.frontendgradleplugin.infrastructure.gradle.SystemSettingsProviderImpl;
import org.siouan.frontendgradleplugin.infrastructure.gradle.TaskContext;
import org.siouan.frontendgradleplugin.infrastructure.gradle.TaskLoggerConfigurer;
import org.siouan.frontendgradleplugin.infrastructure.httpclient.HttpClientProviderImpl;
import org.siouan.frontendgradleplugin.infrastructure.system.ChannelProviderImpl;
import org.siouan.frontendgradleplugin.infrastructure.system.FileManagerImpl;
import org.siouan.frontendgradleplugin.infrastructure.system.PlatformProviderImpl;

public class FrontendGradlePlugin
implements Plugin<Project> {
    public static final String ASSEMBLE_TASK_NAME = "assembleFrontend";
    public static final String CHECK_TASK_NAME = "checkFrontend";
    public static final String CLEAN_TASK_NAME = "cleanFrontend";
    public static final String PUBLISH_TASK_NAME = "publishFrontend";
    public static final String DEFAULT_CACHE_DIRECTORY_NAME = ".frontend-gradle-plugin";
    public static final int DEFAULT_HTTP_PROXY_PORT = 80;
    public static final int DEFAULT_HTTPS_PROXY_PORT = 443;
    public static final String DEFAULT_INSTALL_SCRIPT = "install";
    public static final String DEFAULT_NODE_INSTALL_DIRECTORY_NAME = "node";
    public static final String DEFAULT_NODE_DISTRIBUTION_URL_PATH_PATTERN = "vVERSION/node-vVERSION-ARCH.TYPE";
    public static final String DEFAULT_NODE_DISTRIBUTION_URL_ROOT = "https://nodejs.org/dist/";
    public static final String GRADLE_ASSEMBLE_TASK_NAME = "assemble";
    public static final String GRADLE_CHECK_TASK_NAME = "check";
    public static final String GRADLE_CLEAN_TASK_NAME = "clean";
    public static final String GRADLE_PUBLISH_TASK_NAME = "publish";
    public static final String INSTALL_FRONTEND_TASK_NAME = "installFrontend";
    public static final String INSTALL_PACKAGE_MANAGER_TASK_NAME = "installPackageManager";
    public static final String PACKAGE_JSON_FILE_NAME = "package.json";
    public static final String INSTALL_NODE_TASK_NAME = "installNode";
    public static final String NODEJS_HOME_ENV_VAR = "FGP_NODEJS_HOME";
    public static final String PACKAGE_MANAGER_SPECIFICATION_FILE_NAME = "package-manager-specification.txt";
    public static final String PACKAGE_MANAGER_EXECUTABLE_PATH_FILE_NAME = "package-manager-executable-path.txt";
    public static final String RESOLVE_PACKAGE_MANAGER_TASK_NAME = "resolvePackageManager";
    private static final String EXTENSION_NAME = "frontend";
    private static final String TASK_GROUP = "Frontend";

    public void apply(Project project) {
        project.getPluginManager().apply(BasePlugin.class);
        project.getPluginManager().apply(PublishingPlugin.class);
        SystemExtension systemExtension = new SystemExtension(project.getProviders());
        FrontendExtension frontendExtension = (FrontendExtension)project.getExtensions().create(EXTENSION_NAME, FrontendExtension.class, new Object[]{project.getObjects()});
        frontendExtension.getNodeDistributionProvided().convention((Object)false);
        frontendExtension.getNodeDistributionUrlRoot().convention((Object)DEFAULT_NODE_DISTRIBUTION_URL_ROOT);
        frontendExtension.getNodeDistributionUrlPathPattern().convention((Object)DEFAULT_NODE_DISTRIBUTION_URL_PATH_PATTERN);
        frontendExtension.getInstallScript().convention((Object)DEFAULT_INSTALL_SCRIPT);
        frontendExtension.getPackageJsonDirectory().convention(project.getLayout().getProjectDirectory());
        frontendExtension.getHttpProxyPort().convention((Object)80);
        frontendExtension.getHttpsProxyPort().convention((Object)443);
        frontendExtension.getCacheDirectory().convention(project.getLayout().getProjectDirectory().dir(DEFAULT_CACHE_DIRECTORY_NAME));
        frontendExtension.getInternalPackageJsonFile().fileProvider(frontendExtension.getPackageJsonDirectory().file(PACKAGE_JSON_FILE_NAME).map(RegularFile::getAsFile));
        frontendExtension.getInternalPackageManagerSpecificationFile().convention(frontendExtension.getCacheDirectory().dir(RESOLVE_PACKAGE_MANAGER_TASK_NAME).map(directory -> directory.file(PACKAGE_MANAGER_SPECIFICATION_FILE_NAME)));
        frontendExtension.getInternalPackageManagerExecutablePathFile().convention(frontendExtension.getCacheDirectory().dir(RESOLVE_PACKAGE_MANAGER_TASK_NAME).map(directory -> directory.file(PACKAGE_MANAGER_EXECUTABLE_PATH_FILE_NAME)));
        frontendExtension.getVerboseModeEnabled().convention((Object)false);
        String beanRegistryId = this.configureBeanRegistry(project, systemExtension, frontendExtension);
        this.configureTasks(project, beanRegistryId);
    }

    protected String configureBeanRegistry(Project project, SystemExtension systemExtension, FrontendExtension frontendExtension) {
        String beanRegistryId = Beans.getBeanRegistryId(project.getLayout().getProjectDirectory().toString());
        SystemSettingsProviderImpl systemSettingsProvider = new SystemSettingsProviderImpl(systemExtension, 80, 443);
        PlatformProviderImpl platformProvider = new PlatformProviderImpl(systemSettingsProvider);
        GradleSettings gradleSettings = new GradleSettings(project.getLogging().getLevel(), project.getGradle().getStartParameter().getLogLevel());
        ProviderFactory providerFactory = project.getProviders();
        TaskContext taskContext = TaskContext.builder().defaultNodeInstallDirectoryPath(project.getLayout().getProjectDirectory().getAsFile().toPath().resolve(DEFAULT_NODE_INSTALL_DIRECTORY_NAME)).nodeInstallDirectoryFromEnvironment((Provider<Path>)providerFactory.environmentVariable(NODEJS_HOME_ENV_VAR).map(x$0 -> Paths.get(x$0, new String[0]))).extension(frontendExtension).build();
        Beans.initBeanRegistry(beanRegistryId);
        Beans.registerBean(beanRegistryId, frontendExtension);
        Beans.registerBean(beanRegistryId, systemSettingsProvider);
        Beans.registerBean(beanRegistryId, platformProvider);
        Beans.registerBean(beanRegistryId, gradleSettings);
        Beans.registerBean(beanRegistryId, taskContext);
        Beans.registerBean(beanRegistryId, GradleLoggerAdapter.class);
        Beans.registerBean(beanRegistryId, TaskLoggerConfigurer.class);
        Beans.registerBean(beanRegistryId, ResolveNodeInstallDirectoryPath.class);
        Beans.registerBean(beanRegistryId, FileManagerImpl.class);
        Beans.registerBean(beanRegistryId, ChannelProviderImpl.class);
        Beans.registerBean(beanRegistryId, ArchiverProviderImpl.class);
        Beans.registerBean(beanRegistryId, HttpClientProviderImpl.class);
        return beanRegistryId;
    }

    protected void configureTasks(Project project, String beanRegistryId) {
        TaskContainer taskContainer = project.getTasks();
        TaskContext taskContext = this.getBeanOrFail(beanRegistryId, TaskContext.class);
        taskContainer.register(INSTALL_NODE_TASK_NAME, InstallNodeTask.class, task -> this.configureInstallNodeTask((InstallNodeTask)((Object)task), beanRegistryId, taskContext));
        taskContainer.register(RESOLVE_PACKAGE_MANAGER_TASK_NAME, ResolvePackageManagerTask.class, task -> this.configureResolvePackageManagerTask((ResolvePackageManagerTask)((Object)task), beanRegistryId, taskContainer, taskContext));
        taskContainer.register(INSTALL_PACKAGE_MANAGER_TASK_NAME, InstallPackageManagerTask.class, task -> this.configureInstallPackageManagerTask((InstallPackageManagerTask)((Object)task), beanRegistryId, taskContainer, taskContext));
        taskContainer.register(INSTALL_FRONTEND_TASK_NAME, InstallFrontendTask.class, task -> this.configureInstallFrontendTask((InstallFrontendTask)((Object)task), beanRegistryId, taskContainer, taskContext));
        taskContainer.register(CLEAN_TASK_NAME, CleanTask.class, task -> this.configureCleanTask((CleanTask)((Object)task), beanRegistryId, taskContainer, taskContext));
        taskContainer.register(CHECK_TASK_NAME, CheckTask.class, task -> this.configureCheckTask((CheckTask)((Object)task), beanRegistryId, taskContainer, taskContext));
        taskContainer.register(ASSEMBLE_TASK_NAME, AssembleTask.class, task -> this.configureAssembleTask((AssembleTask)((Object)task), beanRegistryId, taskContainer, taskContext));
        taskContainer.register(PUBLISH_TASK_NAME, PublishTask.class, task -> this.configurePublishTask((PublishTask)((Object)task), beanRegistryId, taskContainer, taskContext));
        this.configureDependency(taskContainer, (Task)GRADLE_CLEAN_TASK_NAME, CLEAN_TASK_NAME, (Class)CleanTask.class);
        this.configureDependency(taskContainer, (Task)GRADLE_ASSEMBLE_TASK_NAME, ASSEMBLE_TASK_NAME, (Class)AssembleTask.class);
        this.configureDependency(taskContainer, (Task)GRADLE_CHECK_TASK_NAME, CHECK_TASK_NAME, (Class)CheckTask.class);
        this.configureDependency(taskContainer, (Task)GRADLE_PUBLISH_TASK_NAME, PUBLISH_TASK_NAME, (Class)PublishTask.class);
    }

    protected void configureInstallNodeTask(InstallNodeTask task, String beanRegistryId, TaskContext taskContext) {
        FrontendExtension extension = taskContext.extension();
        task.setGroup(TASK_GROUP);
        task.setDescription("Downloads and installs a Node.js distribution.");
        task.getNodeVersion().set(extension.getNodeVersion());
        task.getNodeDistributionUrlRoot().set(extension.getNodeDistributionUrlRoot());
        task.getNodeDistributionUrlPathPattern().set(extension.getNodeDistributionUrlPathPattern());
        task.getNodeDistributionServerUsername().set(extension.getNodeDistributionServerUsername());
        task.getNodeDistributionServerPassword().set(extension.getNodeDistributionServerPassword());
        task.getNodeInstallDirectory().set(extension.getNodeInstallDirectory().map(Directory::getAsFile).orElse((Object)taskContext.defaultNodeInstallDirectoryPath().toFile()));
        task.getHttpProxyHost().set(extension.getHttpProxyHost());
        task.getHttpProxyPort().set(extension.getHttpProxyPort());
        task.getHttpProxyUsername().set(extension.getHttpProxyUsername());
        task.getHttpProxyPassword().set(extension.getHttpProxyPassword());
        task.getHttpsProxyHost().set(extension.getHttpsProxyHost());
        task.getHttpsProxyPort().set(extension.getHttpsProxyPort());
        task.getHttpsProxyUsername().set(extension.getHttpsProxyUsername());
        task.getHttpsProxyPassword().set(extension.getHttpsProxyPassword());
        task.getNodeExecutableFile().fileProvider(extension.getNodeInstallDirectory().map(directory -> directory.getAsFile().toPath()).orElse((Object)taskContext.defaultNodeInstallDirectoryPath()).map(nodeInstallDirectoryPath -> this.getBeanOrFail(beanRegistryId, ResolveGlobalNodeExecutablePath.class).execute(ResolveGlobalExecutablePathCommand.builder().nodeInstallDirectoryPath((Path)nodeInstallDirectoryPath).platform(this.getBeanOrFail(beanRegistryId, PlatformProvider.class).getPlatform()).build()).toFile()));
        task.setOnlyIf(t -> (Boolean)extension.getNodeDistributionProvided().get() == false);
    }

    protected void configureResolvePackageManagerTask(ResolvePackageManagerTask task, String beanRegistryId, TaskContainer taskContainer, TaskContext taskContext) {
        FrontendExtension extension = taskContext.extension();
        task.setGroup(TASK_GROUP);
        task.setDescription("Resolves the package manager.");
        task.getPackageJsonFile().set((Provider)extension.getInternalPackageJsonFile());
        task.getNodeInstallDirectory().set(this.resolveNodeInstallDirectory(beanRegistryId, taskContext));
        task.getPackageManagerSpecificationFile().set((Provider)extension.getInternalPackageManagerSpecificationFile());
        task.getPackageManagerExecutablePathFile().set((Provider)extension.getInternalPackageManagerExecutablePathFile());
        task.setOnlyIf(t -> (Boolean)extension.getInternalPackageJsonFile().getAsFile().map(File::toPath).map(x$0 -> Files.exists(x$0, new LinkOption[0])).getOrElse((Object)false));
        this.configureDependency(taskContainer, task, INSTALL_NODE_TASK_NAME, InstallNodeTask.class);
    }

    protected void configureInstallPackageManagerTask(InstallPackageManagerTask task, String beanRegistryId, TaskContainer taskContainer, TaskContext taskContext) {
        FrontendExtension extension = taskContext.extension();
        task.setGroup(TASK_GROUP);
        task.setDescription("Installs the package manager.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory().getAsFile());
        task.getNodeInstallDirectory().set(this.resolveNodeInstallDirectory(beanRegistryId, taskContext));
        TaskProvider resolvePackageManagerTaskProvider = taskContainer.named(RESOLVE_PACKAGE_MANAGER_TASK_NAME, ResolvePackageManagerTask.class);
        task.getPackageManagerSpecificationFile().set(resolvePackageManagerTaskProvider.flatMap(ResolvePackageManagerTask::getPackageManagerSpecificationFile));
        task.getPackageManagerExecutableFile().set(resolvePackageManagerTaskProvider.flatMap(ResolvePackageManagerTask::getPackageManagerExecutablePathFile).map(f -> {
            if (!Files.exists(f.getAsFile().toPath(), new LinkOption[0])) {
                return null;
            }
            try {
                return this.getBeanOrFail(beanRegistryId, FileManager.class).readString(f.getAsFile().toPath(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new GradleException(e.getClass().getName() + ": " + e.getMessage(), (Throwable)e);
            }
        }).map(packageManagerExecutablePathFilePath -> () -> Paths.get(packageManagerExecutablePathFilePath, new String[0]).toFile()));
        task.setOnlyIf(t -> (Boolean)extension.getInternalPackageManagerExecutablePathFile().getAsFile().map(File::toPath).map(x$0 -> Files.exists(x$0, new LinkOption[0])).getOrElse((Object)false));
    }

    protected void configureInstallFrontendTask(InstallFrontendTask task, String beanRegistryId, TaskContainer taskContainer, TaskContext taskContext) {
        FrontendExtension extension = taskContext.extension();
        task.setGroup(TASK_GROUP);
        task.setDescription("Installs frontend dependencies.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory().getAsFile());
        task.getNodeInstallDirectory().set(this.resolveNodeInstallDirectory(beanRegistryId, taskContext));
        task.getExecutableType().set(this.getExecutableType(taskContainer, beanRegistryId));
        task.getInstallScript().set(extension.getInstallScript());
        task.setOnlyIf(t -> (Boolean)extension.getInternalPackageManagerSpecificationFile().getAsFile().map(File::toPath).map(x$0 -> Files.exists(x$0, new LinkOption[0])).getOrElse((Object)false));
        this.configureDependency(taskContainer, task, INSTALL_PACKAGE_MANAGER_TASK_NAME, InstallPackageManagerTask.class);
    }

    protected void configureCleanTask(CleanTask task, String beanRegistryId, TaskContainer taskContainer, TaskContext taskContext) {
        FrontendExtension extension = taskContext.extension();
        task.setGroup(TASK_GROUP);
        task.setDescription("Cleans frontend resources outside the build directory by running a specific script.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory().getAsFile());
        task.getNodeInstallDirectory().set(this.resolveNodeInstallDirectory(beanRegistryId, taskContext));
        task.getExecutableType().set(this.getExecutableType(taskContainer, beanRegistryId));
        task.getCleanScript().set(extension.getCleanScript());
        task.setOnlyIf(t -> extension.getCleanScript().isPresent());
        this.configureDependency(taskContainer, task, INSTALL_FRONTEND_TASK_NAME, InstallFrontendTask.class);
    }

    protected void configureCheckTask(CheckTask task, String beanRegistryId, TaskContainer taskContainer, TaskContext taskContext) {
        FrontendExtension extension = taskContext.extension();
        task.setGroup(TASK_GROUP);
        task.setDescription("Checks frontend by running a specific script.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory().getAsFile());
        task.getNodeInstallDirectory().set(this.resolveNodeInstallDirectory(beanRegistryId, taskContext));
        task.getExecutableType().set(this.getExecutableType(taskContainer, beanRegistryId));
        task.getCheckScript().set(extension.getCheckScript());
        task.setOnlyIf(t -> extension.getCheckScript().isPresent());
        this.configureDependency(taskContainer, task, INSTALL_FRONTEND_TASK_NAME, InstallFrontendTask.class);
    }

    protected void configureAssembleTask(AssembleTask task, String beanRegistryId, TaskContainer taskContainer, TaskContext taskContext) {
        FrontendExtension extension = taskContext.extension();
        task.setGroup(TASK_GROUP);
        task.setDescription("Assembles frontend artifacts by running a specific script.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory().getAsFile());
        task.getNodeInstallDirectory().set(this.resolveNodeInstallDirectory(beanRegistryId, taskContext));
        task.getExecutableType().set(this.getExecutableType(taskContainer, beanRegistryId));
        task.getAssembleScript().set(extension.getAssembleScript());
        task.setOnlyIf(t -> extension.getAssembleScript().isPresent());
        this.configureDependency(taskContainer, task, INSTALL_FRONTEND_TASK_NAME, InstallFrontendTask.class);
    }

    protected void configurePublishTask(PublishTask task, String beanRegistryId, TaskContainer taskContainer, TaskContext taskContext) {
        FrontendExtension extension = taskContext.extension();
        task.setGroup(TASK_GROUP);
        task.setDescription("Publishes frontend artifacts by running a specific script.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory().getAsFile());
        task.getNodeInstallDirectory().set(this.resolveNodeInstallDirectory(beanRegistryId, taskContext));
        task.getExecutableType().set(this.getExecutableType(taskContainer, beanRegistryId));
        task.getPublishScript().set(extension.getPublishScript());
        task.setOnlyIf(t -> extension.getAssembleScript().isPresent() && extension.getPublishScript().isPresent());
        this.configureDependency(taskContainer, task, ASSEMBLE_TASK_NAME, AssembleTask.class);
    }

    private Provider<ExecutableType> getExecutableType(TaskContainer taskContainer, String beanRegistryId) {
        return taskContainer.named(RESOLVE_PACKAGE_MANAGER_TASK_NAME, ResolvePackageManagerTask.class).flatMap(ResolvePackageManagerTask::getPackageManagerSpecificationFile).map(RegularFile::getAsFile).map(f -> {
            try {
                return this.getBeanOrFail(beanRegistryId, ParsePackageManagerSpecification.class).execute(this.getBeanOrFail(beanRegistryId, FileManager.class).readString(f.toPath(), StandardCharsets.UTF_8)).type().getExecutableType();
            }
            catch (IOException | MalformedPackageManagerSpecification | UnsupportedPackageManagerException e) {
                throw new GradleException(e.getClass().getName() + ": " + e.getMessage(), (Throwable)e);
            }
        });
    }

    private <D extends Task> void configureDependency(TaskContainer taskContainer, String taskName, String dependsOnTaskName, Class<D> dependsOnTaskClass) {
        taskContainer.named(taskName, Task.class, task -> this.configureDependency(taskContainer, task, dependsOnTaskName, dependsOnTaskClass));
    }

    private <T extends Task, D extends Task> void configureDependency(TaskContainer taskContainer, T task, String dependsOnTaskName, Class<D> dependsOnTaskClass) {
        task.dependsOn(new Object[]{taskContainer.named(dependsOnTaskName, dependsOnTaskClass).getName()});
    }

    private Provider<File> resolveNodeInstallDirectory(String beanRegistryId, TaskContext taskContext) {
        ResolveNodeInstallDirectoryPath resolveNodeInstallDirectoryPath;
        FrontendExtension extension = taskContext.extension();
        try {
            resolveNodeInstallDirectoryPath = Beans.getBean(beanRegistryId, ResolveNodeInstallDirectoryPath.class);
        }
        catch (BeanInstanciationException | TooManyCandidateBeansException | ZeroOrMultiplePublicConstructorsException e) {
            throw new GradleException(e.getClass().getName() + ": " + e.getMessage(), (Throwable)e);
        }
        return resolveNodeInstallDirectoryPath.execute(ResolveNodeInstallDirectoryPathCommand.builder().nodeInstallDirectoryFromUser((Provider<Path>)extension.getNodeInstallDirectory().getAsFile().map(File::toPath)).nodeDistributionProvided((Provider<Boolean>)extension.getNodeDistributionProvided()).nodeInstallDirectoryFromEnvironment(taskContext.nodeInstallDirectoryFromEnvironment()).defaultPath(taskContext.defaultNodeInstallDirectoryPath()).build()).map(Path::toFile);
    }

    private <T> T getBeanOrFail(String beanRegistryId, Class<T> beanClass) {
        try {
            return Beans.getBean(beanRegistryId, beanClass);
        }
        catch (BeanInstanciationException | TooManyCandidateBeansException | ZeroOrMultiplePublicConstructorsException e) {
            throw new GradleException(e.getClass().getName() + ": " + e.getMessage(), (Throwable)e);
        }
    }
}

