/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.siouan.frontendgradleplugin.domain.exception.ExecutableNotFoundException;
import org.siouan.frontendgradleplugin.domain.model.ExecutionSettings;
import org.siouan.frontendgradleplugin.domain.model.Platform;
import org.siouan.frontendgradleplugin.domain.usecase.GetNodeExecutablePath;
import org.siouan.frontendgradleplugin.domain.usecase.GetNpmExecutablePath;
import org.siouan.frontendgradleplugin.domain.usecase.GetNpxExecutablePath;
import org.siouan.frontendgradleplugin.domain.usecase.GetYarnExecutablePath;
import org.siouan.frontendgradleplugin.domain.util.StringSplitter;

public class ResolveExecutionSettings {
    public static final Path WINDOWS_EXECUTABLE_PATH = Paths.get("cmd", new String[0]);
    public static final String WINDOWS_EXECUTABLE_AUTOEXIT_FLAG = "/c";
    public static final Path UNIX_EXECUTABLE_PATH = Paths.get("sh", new String[0]);
    public static final String UNIX_EXECUTABLE_AUTOEXIT_FLAG = "-c";
    public static final char UNIX_SCRIPT_ARG_SEPARATOR_CHAR = ' ';
    public static final char UNIX_SCRIPT_ARG_ESCAPE_CHAR = '\\';
    private final GetNodeExecutablePath getNodeExecutablePath;
    private final GetNpmExecutablePath getNpmExecutablePath;
    private final GetNpxExecutablePath getNpxExecutablePath;
    private final GetYarnExecutablePath getYarnExecutablePath;

    public ResolveExecutionSettings(GetNodeExecutablePath getNodeExecutablePath, GetNpmExecutablePath getNpmExecutablePath, GetNpxExecutablePath getNpxExecutablePath, GetYarnExecutablePath getYarnExecutablePath) {
        this.getNodeExecutablePath = getNodeExecutablePath;
        this.getNpmExecutablePath = getNpmExecutablePath;
        this.getNpxExecutablePath = getNpxExecutablePath;
        this.getYarnExecutablePath = getYarnExecutablePath;
    }

    @Nonnull
    public ExecutionSettings execute(@Nonnull Path packageJsonDirectoryPath, @Nonnull String executableType, @Nullable Path nodeInstallDirectoryPath, @Nullable Path yarnInstallDirectoryPath, @Nonnull Platform platform, @Nonnull String script) throws ExecutableNotFoundException {
        Path nodeExecutableParentPath;
        Path executable;
        Path scriptExecutablePath;
        Path nodeExecutablePath = this.getNodeExecutablePath.execute(nodeInstallDirectoryPath, platform);
        switch (executableType) {
            case "node": {
                scriptExecutablePath = nodeExecutablePath;
                break;
            }
            case "npm": {
                scriptExecutablePath = this.getNpmExecutablePath.execute(nodeInstallDirectoryPath, platform);
                break;
            }
            case "npx": {
                scriptExecutablePath = this.getNpxExecutablePath.execute(nodeInstallDirectoryPath, platform);
                break;
            }
            case "yarn": {
                scriptExecutablePath = this.getYarnExecutablePath.execute(yarnInstallDirectoryPath, platform);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type of execution: " + executableType);
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        if (platform.isWindowsOs()) {
            executable = WINDOWS_EXECUTABLE_PATH;
            args.add(WINDOWS_EXECUTABLE_AUTOEXIT_FLAG);
            if (scriptExecutablePath.getParent() == null) {
                args.add(scriptExecutablePath.toString() + ' ' + script.trim());
            } else {
                args.add('\"' + scriptExecutablePath.toString() + "\" " + script.trim());
            }
        } else {
            executable = UNIX_EXECUTABLE_PATH;
            args.add(UNIX_EXECUTABLE_AUTOEXIT_FLAG);
            args.add(scriptExecutablePath.toString() + ' ' + String.join((CharSequence)Character.toString(' '), new StringSplitter(' ', '\\').execute(script.trim())));
        }
        HashSet<Path> executablePaths = new HashSet<Path>();
        if (!executableType.equals("node") && (nodeExecutableParentPath = nodeExecutablePath.getParent()) != null) {
            executablePaths.add(nodeExecutableParentPath);
        }
        return new ExecutionSettings(packageJsonDirectoryPath, executablePaths, executable, args);
    }
}

