/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.provider.ChannelProvider;
import org.siouan.frontendgradleplugin.domain.usecase.ConvertToHexadecimalString;

public class HashFile {
    private static final int BUFFER_CAPACITY = 8192;
    private final ChannelProvider channelProvider;
    private final ConvertToHexadecimalString convertToHexadecimalString;
    private final MessageDigest messageDigest;

    public HashFile(ChannelProvider channelProvider, ConvertToHexadecimalString convertToHexadecimalString) throws NoSuchAlgorithmException {
        this.channelProvider = channelProvider;
        this.convertToHexadecimalString = convertToHexadecimalString;
        this.messageDigest = MessageDigest.getInstance("SHA-256");
    }

    @Nonnull
    public String execute(@Nonnull Path filePath) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        try (SeekableByteChannel inputChannel = this.channelProvider.getSeekableByteChannel(filePath);){
            int numberOfBytesRead = inputChannel.read(buffer);
            while (numberOfBytesRead != -1) {
                this.flipBuffer(buffer);
                this.messageDigest.update(buffer);
                this.clearBuffer(buffer);
                numberOfBytesRead = inputChannel.read(buffer);
            }
        }
        return this.convertToHexadecimalString.execute(this.messageDigest.digest());
    }

    private void flipBuffer(@Nonnull Buffer buffer) {
        buffer.flip();
    }

    private void clearBuffer(@Nonnull Buffer buffer) {
        buffer.clear();
    }
}

