/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.model.Credentials;
import org.siouan.frontendgradleplugin.domain.model.Logger;

public class ApplyAuthorization {
    public static final String AUTHORIZATION_TYPE = "Basic";
    public static final String SECURITY_WARNING = "SECURITY WARNING: using basic authentication scheme with non-secure protocols exposes credentials. Consider using HTTPS protocol for URL: '{}'";
    private static final String HTTPS_PROTOCOL = "https";
    private final Logger logger;

    public ApplyAuthorization(Logger logger) {
        this.logger = logger;
    }

    public void execute(@Nonnull URLConnection urlConnection, @Nonnull String authorizationKeyName, @Nonnull Credentials credentials) {
        URL url = urlConnection.getURL();
        if (!url.getProtocol().equalsIgnoreCase(HTTPS_PROTOCOL)) {
            this.logger.warn(SECURITY_WARNING, url);
        }
        String basicCredentials = credentials.getUsername() + ':' + credentials.getPassword();
        urlConnection.setRequestProperty(authorizationKeyName, "Basic " + Base64.getEncoder().encodeToString(basicCredentials.getBytes()));
    }
}

