/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.siouan.frontendgradleplugin.domain.model.Environment;
import org.siouan.frontendgradleplugin.domain.model.Platform;
import org.siouan.frontendgradleplugin.domain.util.SystemUtils;
import org.siouan.frontendgradleplugin.infrastructure.BeanRegistry;
import org.siouan.frontendgradleplugin.infrastructure.BeanRegistryException;
import org.siouan.frontendgradleplugin.infrastructure.Beans;
import org.siouan.frontendgradleplugin.infrastructure.gradle.AssembleTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.CheckTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.CleanTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.FrontendExtension;
import org.siouan.frontendgradleplugin.infrastructure.gradle.InstallTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.NodeInstallTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.PublishTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.TaskLoggerConfigurer;
import org.siouan.frontendgradleplugin.infrastructure.gradle.YarnInstallTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.adapter.GradleLoggerAdapter;
import org.siouan.frontendgradleplugin.infrastructure.provider.ArchiverProviderImpl;
import org.siouan.frontendgradleplugin.infrastructure.provider.ChannelProviderImpl;
import org.siouan.frontendgradleplugin.infrastructure.provider.FileManagerImpl;
import org.siouan.frontendgradleplugin.infrastructure.provider.URLConnectionProviderImpl;

public class FrontendGradlePlugin
implements Plugin<Project> {
    public static final String ASSEMBLE_TASK_NAME = "assembleFrontend";
    public static final String CHECK_TASK_NAME = "checkFrontend";
    public static final String CLEAN_TASK_NAME = "cleanFrontend";
    public static final String PUBLISH_TASK_NAME = "publishFrontend";
    public static final String DEFAULT_NODE_INSTALL_DIRNAME = "node";
    public static final String DEFAULT_NODE_DISTRIBUTION_URL_PATH_PATTERN = "vVERSION/node-vVERSION-ARCH.TYPE";
    public static final String DEFAULT_NODE_DISTRIBUTION_URL_ROOT = "https://nodejs.org/dist/";
    public static final int DEFAULT_PROXY_PORT = 8080;
    public static final String DEFAULT_YARN_DISTRIBUTION_URL_PATH_PATTERN = "vVERSION/yarn-vVERSION.tar.gz";
    public static final String DEFAULT_YARN_DISTRIBUTION_URL_ROOT = "https://github.com/yarnpkg/yarn/releases/download/";
    public static final String DEFAULT_YARN_INSTALL_DIRNAME = "yarn";
    public static final String INSTALL_TASK_NAME = "installFrontend";
    public static final String NODE_INSTALL_TASK_NAME = "installNode";
    public static final String NODEJS_HOME_ENV_VAR = "NODEJS_HOME";
    public static final String YARN_HOME_ENV_VAR = "YARN_HOME";
    public static final String YARN_INSTALL_TASK_NAME = "installYarn";
    public static final String GRADLE_CHECK_TASK_NAME = "check";
    private static final String DEFAULT_INSTALL_SCRIPT = "install";
    private static final String EXTENSION_NAME = "frontend";
    private static final String TASK_GROUP = "Frontend";

    public void apply(Project project) {
        project.getPluginManager().apply(BasePlugin.class);
        project.getPluginManager().apply(PublishingPlugin.class);
        FrontendExtension extension = (FrontendExtension)project.getExtensions().create(EXTENSION_NAME, FrontendExtension.class, new Object[]{project});
        extension.getNodeDistributionProvided().convention((Object)false);
        extension.getNodeDistributionUrlRoot().convention((Object)DEFAULT_NODE_DISTRIBUTION_URL_ROOT);
        extension.getNodeDistributionUrlPathPattern().convention((Object)DEFAULT_NODE_DISTRIBUTION_URL_PATH_PATTERN);
        extension.getNodeInstallDirectory().convention(project.getLayout().getProjectDirectory().dir(DEFAULT_NODE_INSTALL_DIRNAME));
        extension.getYarnEnabled().convention((Object)false);
        extension.getYarnDistributionProvided().convention((Object)false);
        extension.getYarnDistributionUrlRoot().convention((Object)DEFAULT_YARN_DISTRIBUTION_URL_ROOT);
        extension.getYarnDistributionUrlPathPattern().convention((Object)DEFAULT_YARN_DISTRIBUTION_URL_PATH_PATTERN);
        extension.getYarnInstallDirectory().convention(project.getLayout().getProjectDirectory().dir(DEFAULT_YARN_INSTALL_DIRNAME));
        extension.getInstallScript().convention((Object)DEFAULT_INSTALL_SCRIPT);
        extension.getPackageJsonDirectory().convention((Object)project.getLayout().getProjectDirectory().getAsFile());
        extension.getProxyPort().convention((Object)8080);
        extension.getVerboseModeEnabled().convention((Object)false);
        TaskContainer taskContainer = project.getTasks();
        taskContainer.register(NODE_INSTALL_TASK_NAME, NodeInstallTask.class, task -> this.configureNodeInstallTask((NodeInstallTask)((Object)task), extension));
        taskContainer.register(YARN_INSTALL_TASK_NAME, YarnInstallTask.class, task -> this.configureYarnInstallTask((YarnInstallTask)((Object)task), extension));
        taskContainer.register(INSTALL_TASK_NAME, InstallTask.class, task -> this.configureInstallTask(taskContainer, (InstallTask)((Object)task), extension));
        taskContainer.register(CLEAN_TASK_NAME, CleanTask.class, task -> this.configureCleanTask(taskContainer, (CleanTask)((Object)task), extension));
        taskContainer.register(CHECK_TASK_NAME, CheckTask.class, task -> this.configureCheckTask(taskContainer, (CheckTask)((Object)task), extension));
        taskContainer.register(ASSEMBLE_TASK_NAME, AssembleTask.class, task -> this.configureAssembleTask(taskContainer, (AssembleTask)((Object)task), extension));
        taskContainer.register(PUBLISH_TASK_NAME, PublishTask.class, task -> this.configurePublishTask(taskContainer, (PublishTask)((Object)task), extension));
        this.configureDependency(taskContainer, (Task)"clean", CLEAN_TASK_NAME, (Class)CleanTask.class);
        this.configureDependency(taskContainer, (Task)"assemble", ASSEMBLE_TASK_NAME, (Class)AssembleTask.class);
        this.configureDependency(taskContainer, (Task)GRADLE_CHECK_TASK_NAME, CHECK_TASK_NAME, (Class)CheckTask.class);
        this.configureDependency(taskContainer, (Task)"publish", PUBLISH_TASK_NAME, (Class)PublishTask.class);
        Path nodejsHomePath = this.getEnvironmentVariable(NODEJS_HOME_ENV_VAR).map(x$0 -> Paths.get(x$0, new String[0])).orElse(null);
        Path yarnHomePath = this.getEnvironmentVariable(YARN_HOME_ENV_VAR).map(x$0 -> Paths.get(x$0, new String[0])).orElse(null);
        Beans.init();
        Beans.registerBean(new Platform(SystemUtils.getSystemJvmArch(), SystemUtils.getSystemOsName(), new Environment(nodejsHomePath, yarnHomePath)));
        Beans.registerBean(GradleLoggerAdapter.class);
        Beans.registerBean(FileManagerImpl.class);
        Beans.registerBean(ChannelProviderImpl.class);
        Beans.registerBean(ArchiverProviderImpl.class);
        Beans.registerBean(URLConnectionProviderImpl.class);
        try {
            project.getGradle().addListener((Object)new TaskLoggerConfigurer(Beans.getBean(BeanRegistry.class), extension));
            project.getLogger().debug("Platform: {}", (Object)Beans.getBean(Platform.class));
        }
        catch (BeanRegistryException e) {
            throw new GradleException("Cannot get instance of bean registry", (Throwable)e);
        }
        project.afterEvaluate(p -> this.finalizeExtension(extension));
    }

    private void finalizeExtension(@Nonnull FrontendExtension extension) {
        if (((Boolean)extension.getNodeDistributionProvided().get()).booleanValue()) {
            extension.getNodeInstallDirectory().convention((Directory)null);
        }
        if (((Boolean)extension.getYarnDistributionProvided().get()).booleanValue()) {
            extension.getYarnInstallDirectory().convention((Directory)null);
        }
    }

    private void configureNodeInstallTask(NodeInstallTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Downloads and installs a Node distribution.");
        task.getNodeVersion().set(extension.getNodeVersion());
        task.getNodeDistributionUrlRoot().set(extension.getNodeDistributionUrlRoot());
        task.getNodeDistributionUrlPathPattern().set(extension.getNodeDistributionUrlPathPattern());
        task.getNodeDistributionServerUsername().set(extension.getNodeDistributionServerUsername());
        task.getNodeDistributionServerPassword().set(extension.getNodeDistributionServerPassword());
        task.getNodeInstallDirectory().set((Provider)extension.getNodeInstallDirectory());
        task.getProxyHost().set(extension.getProxyHost());
        task.getProxyPort().set(extension.getProxyPort());
        task.getProxyUsername().set(extension.getProxyUsername());
        task.getProxyPassword().set(extension.getProxyPassword());
        task.setOnlyIf(t -> (Boolean)extension.getNodeDistributionProvided().get() == false);
    }

    private void configureYarnInstallTask(YarnInstallTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Downloads and installs a Yarn distribution.");
        task.getYarnVersion().set(extension.getYarnVersion());
        task.getYarnDistributionUrlRoot().set(extension.getYarnDistributionUrlRoot());
        task.getYarnDistributionUrlPathPattern().set(extension.getYarnDistributionUrlPathPattern());
        task.getYarnInstallDirectory().set((Provider)extension.getYarnInstallDirectory());
        task.getYarnDistributionServerUsername().set(extension.getYarnDistributionServerUsername());
        task.getYarnDistributionServerPassword().set(extension.getYarnDistributionServerPassword());
        task.getProxyHost().set(extension.getProxyHost());
        task.getProxyPort().set(extension.getProxyPort());
        task.getProxyUsername().set(extension.getProxyUsername());
        task.getProxyPassword().set(extension.getProxyPassword());
        task.setOnlyIf(t -> (Boolean)extension.getYarnEnabled().get() != false && (Boolean)extension.getYarnDistributionProvided().get() == false);
    }

    private void configureInstallTask(TaskContainer taskContainer, InstallTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Installs/updates frontend dependencies.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory());
        task.getNodeInstallDirectory().set((Provider)extension.getNodeInstallDirectory());
        task.getYarnEnabled().set(extension.getYarnEnabled());
        task.getYarnInstallDirectory().set((Provider)extension.getYarnInstallDirectory());
        task.getInstallScript().set(extension.getInstallScript());
        this.configureDependency(taskContainer, task, NODE_INSTALL_TASK_NAME, NodeInstallTask.class);
        this.configureDependency(taskContainer, task, YARN_INSTALL_TASK_NAME, YarnInstallTask.class);
    }

    private void configureCleanTask(TaskContainer taskContainer, CleanTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Cleans frontend resources outside the build directory by running a specific script.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory());
        task.getNodeInstallDirectory().set((Provider)extension.getNodeInstallDirectory());
        task.getYarnEnabled().set(extension.getYarnEnabled());
        task.getYarnInstallDirectory().set((Provider)extension.getYarnInstallDirectory());
        task.getCleanScript().set(extension.getCleanScript());
        task.setOnlyIf(t -> extension.getCleanScript().isPresent());
        this.configureDependency(taskContainer, task, INSTALL_TASK_NAME, InstallTask.class, (cleanTask, installTask) -> cleanTask.getCleanScript().isPresent());
    }

    private void configureCheckTask(TaskContainer taskContainer, CheckTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Checks frontend by running a specific script.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory());
        task.getNodeInstallDirectory().set((Provider)extension.getNodeInstallDirectory());
        task.getYarnEnabled().set(extension.getYarnEnabled());
        task.getYarnInstallDirectory().set((Provider)extension.getYarnInstallDirectory());
        task.getCheckScript().set(extension.getCheckScript());
        task.setOnlyIf(t -> extension.getCheckScript().isPresent());
        this.configureDependency(taskContainer, task, INSTALL_TASK_NAME, InstallTask.class, (checkTask, installTask) -> checkTask.getCheckScript().isPresent());
    }

    private void configureAssembleTask(TaskContainer taskContainer, AssembleTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Assembles frontend artifacts by running a specific script.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory());
        task.getNodeInstallDirectory().set((Provider)extension.getNodeInstallDirectory());
        task.getYarnEnabled().set(extension.getYarnEnabled());
        task.getYarnInstallDirectory().set((Provider)extension.getYarnInstallDirectory());
        task.getAssembleScript().set(extension.getAssembleScript());
        task.setOnlyIf(t -> extension.getAssembleScript().isPresent());
        this.configureDependency(taskContainer, task, INSTALL_TASK_NAME, InstallTask.class, (assembleTask, installTask) -> assembleTask.getAssembleScript().isPresent());
    }

    private void configurePublishTask(TaskContainer taskContainer, PublishTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Publishes frontend artifacts by running a specific script.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory());
        task.getNodeInstallDirectory().set((Provider)extension.getNodeInstallDirectory());
        task.getYarnEnabled().set(extension.getYarnEnabled());
        task.getYarnInstallDirectory().set((Provider)extension.getYarnInstallDirectory());
        task.getPublishScript().set(extension.getPublishScript());
        task.setOnlyIf(t -> extension.getAssembleScript().isPresent() && extension.getPublishScript().isPresent());
        this.configureDependency(taskContainer, task, ASSEMBLE_TASK_NAME, AssembleTask.class, (publishTask, assembleTask) -> publishTask.getPublishScript().isPresent());
    }

    private <D extends Task> void configureDependency(TaskContainer taskContainer, String taskName, String dependsOnTaskName, Class<D> dependsOnTaskClass) {
        taskContainer.named(taskName, Task.class, task -> this.configureDependency(taskContainer, task, dependsOnTaskName, dependsOnTaskClass));
    }

    private <T extends Task, D extends Task> void configureDependency(TaskContainer taskContainer, T task, String dependsOnTaskName, Class<D> dependsOnTaskClass) {
        this.configureDependency(taskContainer, task, dependsOnTaskName, dependsOnTaskClass, null);
    }

    private <T extends Task, D extends Task> void configureDependency(TaskContainer taskContainer, T task, String dependsOnTaskName, Class<D> dependsOnTaskClass, BiPredicate<T, D> condition) {
        TaskProvider dependsOnTask = taskContainer.named(dependsOnTaskName, dependsOnTaskClass);
        if (condition == null || this.canDependOn(task, dependsOnTask, condition)) {
            task.dependsOn(new Object[]{dependsOnTask.getName()});
        }
    }

    private <T extends Task, D extends Task> boolean canDependOn(T task, TaskProvider<D> dependsOnTaskProvider, BiPredicate<T, D> condition) {
        return dependsOnTaskProvider.isPresent() && condition.test(task, dependsOnTaskProvider.get());
    }

    @Nonnull
    private Optional<String> getEnvironmentVariable(@Nonnull String variableName) {
        return Optional.ofNullable(System.getenv(variableName)).filter(value -> !value.trim().isEmpty());
    }
}

