/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.tasks;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.siouan.frontendgradleplugin.core.DistributionInstallJob;
import org.siouan.frontendgradleplugin.core.DistributionUrlResolverException;
import org.siouan.frontendgradleplugin.core.DownloadException;
import org.siouan.frontendgradleplugin.core.DownloaderImpl;
import org.siouan.frontendgradleplugin.core.FileHasherImpl;
import org.siouan.frontendgradleplugin.core.InvalidDistributionException;
import org.siouan.frontendgradleplugin.core.NodeDistributionChecksumReaderImpl;
import org.siouan.frontendgradleplugin.core.NodeDistributionUrlResolver;
import org.siouan.frontendgradleplugin.core.NodeDistributionValidator;
import org.siouan.frontendgradleplugin.core.UnsupportedDistributionArchiveException;

public class NodeInstallTask
extends DefaultTask {
    public static final String DEFAULT_NAME = "installNode";
    private final Property<String> nodeVersion = this.getProject().getObjects().property(String.class);
    private final Property<File> nodeInstallDirectory = this.getProject().getObjects().property(File.class);
    private final Property<String> nodeDistributionUrl = this.getProject().getObjects().property(String.class);

    @Input
    public Property<String> getNodeVersion() {
        return this.nodeVersion;
    }

    @Input
    @Optional
    public Property<String> getNodeDistributionUrl() {
        return this.nodeDistributionUrl;
    }

    @OutputDirectory
    @Optional
    public Property<File> getNodeInstallDirectory() {
        return this.nodeInstallDirectory;
    }

    @TaskAction
    public void execute() throws IOException, InvalidDistributionException, DistributionUrlResolverException, UnsupportedDistributionArchiveException, DownloadException, NoSuchAlgorithmException {
        String version = (String)this.nodeVersion.get();
        String distributionUrl = (String)this.nodeDistributionUrl.getOrNull();
        File installDirectory = (File)this.nodeInstallDirectory.get();
        new DistributionInstallJob((Task)this, new NodeDistributionUrlResolver(version, distributionUrl), new NodeDistributionValidator((Task)this, new DownloaderImpl(this.getTemporaryDir()), new NodeDistributionChecksumReaderImpl(), new FileHasherImpl(), installDirectory), installDirectory).install();
    }
}

