/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.core;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.siouan.frontendgradleplugin.core.DistributionUrlResolver;
import org.siouan.frontendgradleplugin.core.DistributionUrlResolverException;

public final class YarnDistributionUrlResolver
implements DistributionUrlResolver {
    private static final String VERSION_TOKEN = "VERSION";
    private static final String URL_PATTERN = "https://github.com/yarnpkg/yarn/releases/download/vVERSION/yarn-vVERSION.tar.gz";
    private final String version;
    private final String distributionUrl;

    public YarnDistributionUrlResolver(String version, String distributionUrl) {
        this.version = version;
        this.distributionUrl = distributionUrl;
    }

    @Override
    public URL resolve() throws DistributionUrlResolverException {
        String urlAsString = this.distributionUrl == null ? URL_PATTERN.replaceAll(VERSION_TOKEN, this.version) : this.distributionUrl;
        try {
            return URI.create(urlAsString).toURL();
        }
        catch (MalformedURLException e) {
            throw new DistributionUrlResolverException(e);
        }
    }
}

