/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.core;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.stream.Stream;

public final class Utils {
    private Utils() {
    }

    public static void deleteRecursively(Path rootPath, boolean deleteRootEnabled) throws IOException {
        Files.walkFileTree(rootPath, new FileDeleteVisitor(rootPath, deleteRootEnabled));
    }

    public static boolean is64BitsArch(String jreArch) {
        String jreArchLowered = jreArch.toLowerCase();
        return jreArchLowered.contains("x64") || jreArchLowered.contains("amd64") || jreArchLowered.contains("ppc") || jreArchLowered.contains("sparc");
    }

    public static boolean isLinuxOs(String osName) {
        return osName.toLowerCase().contains("linux");
    }

    public static boolean isMacOs(String osName) {
        return osName.toLowerCase().contains("mac os");
    }

    public static boolean isWindowsOs(String osName) {
        return osName.toLowerCase().contains("windows");
    }

    public static void moveFiles(File srcDirectory, File destDirectory) throws IOException {
        if (!srcDirectory.isDirectory() || !destDirectory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        try (Stream<Path> childPaths = Files.list(srcDirectory.toPath());){
            childPaths.forEach(path -> {
                try {
                    Files.move(path, new File(destDirectory, path.getFileName().toString()).toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    public static String removeExtension(String filename) {
        String filenameWithoutExtension = filename.endsWith(".tar.gz") ? filename.substring(0, filename.lastIndexOf(".tar.gz")) : filename.substring(0, filename.lastIndexOf(46));
        return filenameWithoutExtension;
    }

    private static class FileDeleteVisitor
    extends SimpleFileVisitor<Path> {
        private final Path rootPath;
        private final boolean deleteRootEnabled;

        public FileDeleteVisitor(Path rootPath, boolean deleteRootEnabled) {
            this.rootPath = rootPath;
            this.deleteRootEnabled = deleteRootEnabled;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path directory, IOException e) throws IOException {
            if (e == null) {
                if (this.deleteRootEnabled || !directory.equals(this.rootPath)) {
                    Files.delete(directory);
                }
                return FileVisitResult.CONTINUE;
            }
            throw e;
        }
    }
}

