/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import org.gradle.api.Task;
import org.siouan.frontendgradleplugin.core.AbstractJob;
import org.siouan.frontendgradleplugin.core.DistributionValidator;
import org.siouan.frontendgradleplugin.core.DownloadException;
import org.siouan.frontendgradleplugin.core.Downloader;
import org.siouan.frontendgradleplugin.core.FileHasher;
import org.siouan.frontendgradleplugin.core.InvalidDistributionException;
import org.siouan.frontendgradleplugin.core.NodeDistributionChecksumNotFoundException;
import org.siouan.frontendgradleplugin.core.NodeDistributionChecksumReader;

public class NodeDistributionValidator
extends AbstractJob
implements DistributionValidator {
    private final Downloader downloader;
    private final NodeDistributionChecksumReader checksumReader;
    private final FileHasher fileHasher;
    private final File installDirectory;

    public NodeDistributionValidator(Task task, Downloader downloader, NodeDistributionChecksumReader checksumReader, FileHasher fileHasher, File installDirectory) {
        super(task);
        this.downloader = downloader;
        this.checksumReader = checksumReader;
        this.fileHasher = fileHasher;
        this.installDirectory = installDirectory;
    }

    @Override
    public void validate(URL distributionUrl, File distributionFile) throws InvalidDistributionException {
        String distributionUrlAsString = distributionUrl.toString();
        String checksumUrlAsString = distributionUrlAsString.substring(0, distributionUrlAsString.lastIndexOf(47) + 1) + "SHASUMS256.txt";
        File checksumFile = new File(this.installDirectory, checksumUrlAsString.substring(checksumUrlAsString.lastIndexOf(47) + 1));
        try {
            URL checksumUrl = URI.create(checksumUrlAsString).toURL();
            this.logLifecycle("Downloading checksums at '" + checksumUrlAsString + "'");
            this.downloader.download(checksumUrl, checksumFile);
            this.logLifecycle("Verifying distribution integrity");
            String expectedHash = this.checksumReader.readHash(checksumFile, distributionFile.getName());
            if (!this.fileHasher.hash(distributionFile).equals(expectedHash)) {
                throw new InvalidDistributionException("Distribution corrupted: invalid checksum");
            }
        }
        catch (IOException | DownloadException | NodeDistributionChecksumNotFoundException e) {
            throw new InvalidDistributionException(e);
        }
        finally {
            try {
                Files.deleteIfExists(checksumFile.toPath());
            }
            catch (IOException e) {
                this.logWarn("Checksum file could not be deleted: '" + checksumFile.getAbsolutePath() + '\'', e);
            }
        }
    }
}

