/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.core;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Optional;
import org.siouan.frontendgradleplugin.core.DistributionUrlResolver;
import org.siouan.frontendgradleplugin.core.DistributionUrlResolverException;
import org.siouan.frontendgradleplugin.core.Utils;

public class NodeDistributionUrlResolver
implements DistributionUrlResolver {
    private final String version;
    private final String distributionUrl;
    private final String osName;
    private final String jreArch;

    public NodeDistributionUrlResolver(String version, String distributionUrl) {
        this(version, distributionUrl, System.getProperty("os.name"), System.getProperty("os.arch"));
    }

    public NodeDistributionUrlResolver(String version, String distributionUrl, String osName, String jreArch) {
        if (version == null && distributionUrl == null) {
            throw new IllegalArgumentException("Either the Node version or a download URL must be configured (see plugin's DSL).");
        }
        this.version = version;
        this.distributionUrl = distributionUrl;
        this.osName = osName;
        this.jreArch = jreArch;
    }

    @Override
    public URL resolve() throws DistributionUrlResolverException {
        String urlAsString;
        if (this.distributionUrl == null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("https://nodejs.org/dist/v");
            buffer.append(this.version);
            buffer.append("/node-v");
            buffer.append(this.version);
            Optional<String> extension = this.resolveExtension();
            if (!extension.isPresent()) {
                throw new DistributionUrlResolverException("This platform is not supported yet: " + this.osName + ", " + this.jreArch);
            }
            buffer.append(extension.get());
            urlAsString = buffer.toString();
        } else {
            urlAsString = this.distributionUrl;
        }
        try {
            return URI.create(urlAsString).toURL();
        }
        catch (MalformedURLException e) {
            throw new DistributionUrlResolverException(e);
        }
    }

    private Optional<String> resolveExtension() {
        String extension = Utils.is64BitsArch(this.jreArch) ? (Utils.isWindowsOs(this.osName) ? "-win-x64.zip" : (Utils.isLinuxOs(this.osName) ? "-linux-x64.tar.gz" : (Utils.isMacOs(this.osName) ? "-darwin-x64.tar.gz" : null))) : (Utils.isWindowsOs(this.osName) ? "-win-x86.zip" : null);
        return Optional.ofNullable(extension);
    }
}

