/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.siouan.frontendgradleplugin.core.FileHasher;

public class FileHasherImpl
implements FileHasher {
    private static final int BUFFER_CAPACITY = 8192;
    private final MessageDigest digest = MessageDigest.getInstance("SHA-256");

    @Override
    public String hash(File inputFile) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        try (FileInputStream inputStream = new FileInputStream(inputFile);){
            FileChannel inputChannel = inputStream.getChannel();
            int numberOfBytesRead = inputChannel.read(buffer);
            while (numberOfBytesRead != -1) {
                buffer.flip();
                this.digest.update(buffer);
                buffer.clear();
                numberOfBytesRead = inputChannel.read(buffer);
            }
        }
        return this.toHexadecimalString(this.digest.digest());
    }

    private String toHexadecimalString(byte[] hash) {
        StringBuilder hexadecimalString = new StringBuilder();
        for (byte digit : hash) {
            String hexadecimalDigit = Integer.toHexString(0xFF & digit);
            if (hexadecimalDigit.length() == 1) {
                hexadecimalString.append(0);
            }
            hexadecimalString.append(hexadecimalDigit);
        }
        return hexadecimalString.toString();
    }
}

