/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import org.gradle.api.Action;
import org.gradle.process.ExecSpec;
import org.siouan.frontendgradleplugin.core.Utils;

public class ExecSpecAction
implements Action<ExecSpec> {
    public static final String SHELL_EXECUTABLE = "sh";
    public static final String CMD_EXECUTABLE = "cmd";
    public static final String NPM_EXECUTABLE = "npm";
    public static final String YARN_EXECUTABLE = "yarn";
    private final boolean yarnEnabled;
    private final File nodeInstallDirectory;
    private final File yarnInstallDirectory;
    private final String script;
    private final Consumer<ExecSpec> afterConfigured;
    private final String osName;

    public ExecSpecAction(boolean yarnEnabled, File nodeInstallDirectory, File yarnInstallDirectory, String script, Consumer<ExecSpec> afterConfigured) {
        this(yarnEnabled, nodeInstallDirectory, yarnInstallDirectory, script, afterConfigured, System.getProperty("os.name"));
    }

    public ExecSpecAction(boolean yarnEnabled, File nodeInstallDirectory, File yarnInstallDirectory, String script, Consumer<ExecSpec> afterConfigured, String osName) {
        this.yarnEnabled = yarnEnabled;
        this.nodeInstallDirectory = nodeInstallDirectory;
        this.yarnInstallDirectory = yarnInstallDirectory;
        this.script = script;
        this.afterConfigured = afterConfigured;
        this.osName = osName;
    }

    public void execute(ExecSpec execSpec) {
        String executable;
        ArrayList<String> args = new ArrayList<String>();
        if (Utils.isWindowsOs(this.osName)) {
            executable = CMD_EXECUTABLE;
            args.add("/c");
            String scriptExecutable = this.yarnEnabled ? YARN_EXECUTABLE : NPM_EXECUTABLE;
            args.add(scriptExecutable + ' ' + this.script.trim());
        } else {
            executable = this.yarnEnabled ? YARN_EXECUTABLE : NPM_EXECUTABLE;
            args.addAll(Arrays.asList(this.script.trim().split("\\s+")));
        }
        Map environment = execSpec.getEnvironment();
        String pathVariable = this.findPathVariable(environment);
        StringBuilder pathValue = new StringBuilder(this.nodeInstallDirectory.getAbsolutePath());
        pathValue.append(File.pathSeparatorChar);
        if (this.yarnEnabled) {
            pathValue.append(this.yarnInstallDirectory.getAbsolutePath());
            pathValue.append(File.separatorChar);
            pathValue.append("bin");
            pathValue.append(File.pathSeparatorChar);
        }
        pathValue.append(environment.getOrDefault(pathVariable, ""));
        execSpec.environment(pathVariable, (Object)pathValue.toString());
        execSpec.setExecutable(executable);
        execSpec.setArgs(args);
        this.afterConfigured.accept(execSpec);
    }

    public boolean isYarnEnabled() {
        return this.yarnEnabled;
    }

    public File getNodeInstallDirectory() {
        return this.nodeInstallDirectory;
    }

    public File getYarnInstallDirectory() {
        return this.yarnInstallDirectory;
    }

    public String getScript() {
        return this.script;
    }

    private String findPathVariable(Map<String, Object> environment) {
        String pathVariable = environment.containsKey("Path") ? "Path" : "PATH";
        return pathVariable;
    }
}

