/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.siouan.frontendgradleplugin.core.DownloadException;
import org.siouan.frontendgradleplugin.core.Downloader;

public class DownloaderImpl
implements Downloader {
    private final File temporaryDirectory;

    public DownloaderImpl(File temporaryDirectory) {
        this.temporaryDirectory = temporaryDirectory;
    }

    @Override
    public void download(URL resourceUrl, File destinationFile) throws DownloadException {
        String resourceName = new File(resourceUrl.getPath()).getName();
        File downloadedFile = new File(this.temporaryDirectory, resourceName);
        try (ReadableByteChannel readableByteChannel = Channels.newChannel(resourceUrl.openStream());
             FileOutputStream fileOutputStream = new FileOutputStream(downloadedFile);){
            fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        }
        catch (IOException e) {
            throw new DownloadException("Resource at '" + resourceUrl + "' could not be downloaded.", e);
        }
        try {
            Files.move(downloadedFile.toPath(), destinationFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new DownloadException("Destination '" + destinationFile.getPath() + "' could not be created.", e);
        }
    }
}

