/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileTree;
import org.siouan.frontendgradleplugin.core.AbstractJob;
import org.siouan.frontendgradleplugin.core.DistributionUrlResolver;
import org.siouan.frontendgradleplugin.core.DistributionUrlResolverException;
import org.siouan.frontendgradleplugin.core.DistributionValidator;
import org.siouan.frontendgradleplugin.core.DownloadException;
import org.siouan.frontendgradleplugin.core.DownloaderImpl;
import org.siouan.frontendgradleplugin.core.InvalidDistributionException;
import org.siouan.frontendgradleplugin.core.UnsupportedDistributionArchiveException;
import org.siouan.frontendgradleplugin.core.Utils;

public class DistributionInstallJob
extends AbstractJob {
    private final File installDirectory;
    private final DistributionUrlResolver urlResolver;
    private final DistributionValidator validator;

    public DistributionInstallJob(Task task, DistributionUrlResolver urlResolver, DistributionValidator validator, File installDirectory) {
        super(task);
        this.urlResolver = urlResolver;
        this.validator = validator;
        this.installDirectory = installDirectory;
    }

    public void install() throws InvalidDistributionException, IOException, DistributionUrlResolverException, DownloadException, UnsupportedDistributionArchiveException {
        Function<Object, FileTree> extractFunction;
        Project project = this.task.getProject();
        this.checkInstallDirectory();
        URL distributionUrl = this.urlResolver.resolve();
        String distributionUrlAsString = distributionUrl.toString();
        this.logLifecycle("Downloading distribution at '" + distributionUrlAsString + "'");
        DownloaderImpl downloader = new DownloaderImpl(this.task.getTemporaryDir());
        File distributionFile = new File(this.installDirectory, distributionUrlAsString.substring(distributionUrlAsString.lastIndexOf(47) + 1));
        downloader.download(distributionUrl, distributionFile);
        if (this.validator != null) {
            this.validator.validate(distributionUrl, distributionFile);
        }
        this.logLifecycle("Extracting distribution into '" + distributionFile.getParent() + "'");
        if (distributionFile.getName().endsWith(".zip")) {
            extractFunction = arg_0 -> ((Project)project).zipTree(arg_0);
        } else if (distributionFile.getName().endsWith(".tar.gz")) {
            extractFunction = arg_0 -> ((Project)project).tarTree(arg_0);
        } else {
            this.logError("Unsupported type of archive: " + distributionFile.getName());
            throw new UnsupportedDistributionArchiveException();
        }
        project.copy(copySpec -> {
            copySpec.from(new Object[]{extractFunction.apply(distributionFile)});
            copySpec.into((Object)distributionFile.getParent());
        });
        File distributionRootDirectory = new File(distributionFile.getParentFile(), Utils.removeExtension(distributionFile.getName()));
        Utils.moveFiles(distributionRootDirectory, distributionFile.getParentFile());
        Files.delete(distributionRootDirectory.toPath());
        this.logLifecycle("Removing distribution file '" + distributionFile.getAbsolutePath() + "'");
        Files.delete(distributionFile.toPath());
        this.logLifecycle("Distribution installed in '" + distributionFile.getParent() + "'");
    }

    private void checkInstallDirectory() throws IOException {
        Files.createDirectories(this.installDirectory.toPath(), new FileAttribute[0]);
        this.logLifecycle("Removing content in install directory '" + this.installDirectory.getAbsolutePath() + "'.");
        Utils.deleteRecursively(this.installDirectory.toPath(), false);
    }
}

