/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin;

import java.io.File;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.tasks.TaskContainer;
import org.siouan.frontendgradleplugin.FrontendExtension;
import org.siouan.frontendgradleplugin.tasks.AssembleTask;
import org.siouan.frontendgradleplugin.tasks.CheckTask;
import org.siouan.frontendgradleplugin.tasks.CleanTask;
import org.siouan.frontendgradleplugin.tasks.InstallTask;
import org.siouan.frontendgradleplugin.tasks.NodeInstallTask;
import org.siouan.frontendgradleplugin.tasks.RunScriptTask;
import org.siouan.frontendgradleplugin.tasks.YarnInstallTask;

public class FrontendGradlePlugin
implements Plugin<Project> {
    public static final String DEFAULT_NODE_INSTALL_DIRNAME = "node";
    public static final String DEFAULT_YARN_INSTALL_DIRNAME = "yarn";
    private static final String EXTENSION_NAME = "frontend";
    private static final String TASK_GROUP = "Frontend";

    public void apply(Project project) {
        project.getPluginManager().apply(BasePlugin.class);
        FrontendExtension extension = (FrontendExtension)project.getExtensions().create(EXTENSION_NAME, FrontendExtension.class, new Object[]{project});
        extension.getNodeInstallDirectory().convention((Object)new File(project.getProjectDir(), DEFAULT_NODE_INSTALL_DIRNAME));
        extension.getYarnEnabled().convention((Object)false);
        extension.getYarnInstallDirectory().convention((Object)new File(project.getProjectDir(), DEFAULT_YARN_INSTALL_DIRNAME));
        TaskContainer projectTasks = project.getTasks();
        projectTasks.register("installNode", NodeInstallTask.class, task -> this.configureTask((NodeInstallTask)((Object)task), extension));
        projectTasks.register("installYarn", YarnInstallTask.class, task -> this.configureTask((YarnInstallTask)((Object)task), extension));
        projectTasks.register("installFrontend", InstallTask.class, task -> this.configureTask((InstallTask)((Object)task), extension));
        projectTasks.register("cleanFrontend", CleanTask.class, task -> this.configureTask((CleanTask)((Object)task), extension));
        projectTasks.named("clean", task -> task.dependsOn(new Object[]{projectTasks.named("cleanFrontend")}));
        projectTasks.register("checkFrontend", CheckTask.class, task -> this.configureTask((CheckTask)((Object)task), extension));
        projectTasks.named("check", task -> task.dependsOn(new Object[]{projectTasks.named("checkFrontend")}));
        projectTasks.register("assembleFrontend", AssembleTask.class, task -> this.configureTask((AssembleTask)((Object)task), extension));
        projectTasks.named("assemble", task -> task.dependsOn(new Object[]{projectTasks.named("assembleFrontend")}));
        projectTasks.register("runScriptFrontend", RunScriptTask.class, this::configureTask);
    }

    private void configureTask(NodeInstallTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Downloads and installs a Node distribution.");
        task.getNodeVersion().set(extension.getNodeVersion());
        task.getNodeDistributionUrl().set(extension.getNodeDistributionUrl());
        task.getNodeInstallDirectory().set(extension.getNodeInstallDirectory());
    }

    private void configureTask(YarnInstallTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Downloads and installs a Yarn distribution.");
        task.setEnabled((Boolean)extension.getYarnEnabled().get());
        task.getYarnVersion().set(extension.getYarnVersion());
        task.getYarnDistributionUrl().set(extension.getYarnDistributionUrl());
        task.getYarnInstallDirectory().set(extension.getYarnInstallDirectory());
    }

    private void configureTask(InstallTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Installs/updates frontend dependencies.");
        task.getYarnEnabled().set(extension.getYarnEnabled());
        task.getNodeInstallDirectory().set(extension.getNodeInstallDirectory());
        task.getYarnInstallDirectory().set(extension.getYarnInstallDirectory());
        task.dependsOn(new Object[]{"installNode", "installYarn"});
    }

    private void configureTask(CleanTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Cleans frontend resources outside the build directory by running a specific script.");
        task.getYarnEnabled().set(extension.getYarnEnabled());
        task.getNodeInstallDirectory().set(extension.getNodeInstallDirectory());
        task.getYarnInstallDirectory().set(extension.getYarnInstallDirectory());
        task.getCleanScript().set(extension.getCleanScript());
        task.dependsOn(new Object[]{"installFrontend"});
    }

    private void configureTask(CheckTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Checks frontend by running a specific script.");
        task.getYarnEnabled().set(extension.getYarnEnabled());
        task.getNodeInstallDirectory().set(extension.getNodeInstallDirectory());
        task.getYarnInstallDirectory().set(extension.getYarnInstallDirectory());
        task.getCheckScript().set(extension.getCheckScript());
        task.dependsOn(new Object[]{"installFrontend"});
    }

    private void configureTask(AssembleTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Assembles the frontend by running a specific script.");
        task.getYarnEnabled().set(extension.getYarnEnabled());
        task.getNodeInstallDirectory().set(extension.getNodeInstallDirectory());
        task.getYarnInstallDirectory().set(extension.getYarnInstallDirectory());
        task.getAssembleScript().set(extension.getAssembleScript());
        task.dependsOn(new Object[]{"installFrontend"});
    }

    private void configureTask(RunScriptTask task) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Runs a frontend script.");
        task.dependsOn(new Object[]{"installFrontend"});
    }
}

